% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{post_draws}
\alias{post_draws}
\alias{post_draws.default}
\alias{generate_draws}
\alias{generate_draws.gam}
\title{Low-level Functions to generate draws from the posterior distribution of
model coefficients}
\usage{
post_draws(model, ...)

\method{post_draws}{default}(
  model,
  n,
  method = c("gaussian", "mh", "inla", "user"),
  mu = NULL,
  sigma = NULL,
  n_cores = 1L,
  burnin = 1000,
  thin = 1,
  t_df = 40,
  rw_scale = 0.25,
  index = NULL,
  frequentist = FALSE,
  unconditional = FALSE,
  parametrized = TRUE,
  mvn_method = c("mvnfast", "mgcv"),
  draws = NULL,
  seed = NULL,
  ...
)

generate_draws(model, ...)

\method{generate_draws}{gam}(
  model,
  n,
  method = c("gaussian", "mh", "inla"),
  mu = NULL,
  sigma = NULL,
  n_cores = 1L,
  burnin = 1000,
  thin = 1,
  t_df = 40,
  rw_scale = 0.25,
  index = NULL,
  frequentist = FALSE,
  unconditional = FALSE,
  mvn_method = c("mvnfast", "mgcv"),
  seed = NULL,
  ...
)
}
\arguments{
\item{model}{a fitted R model. Currently only models fitted by \code{mgcv::gam()}
or \code{mgcv::bam()}, or return an object that \emph{inherits} from such objects are
supported. Here, "inherits" is used in a loose fashion; models fitted by
\code{scam::scam()} are support even though those models don't strictly inherit
from class \code{"gam"} as far as \code{inherits()} is concerned.}

\item{...}{arguments passed to methods.}

\item{n}{numeric; the number of posterior draws to take.}

\item{method}{character; which algorithm to use to sample from the posterior.
Currently implemented methods are: \code{"gaussian"} and \code{"mh"}. \code{"gaussian"}
calls \code{gaussian_draws()} which uses a Gaussian approximation to the
posterior distribution. \code{"mh"} uses a simple Metropolis Hastings sampler
which alternates static proposals based on a Gaussian approximation to the
posterior, with random walk proposals. Note, setting \code{t_df} to a low value
will result in heavier-tailed statistic proposals. See \code{mgcv::gam.mh()}
for more details.}

\item{mu}{numeric; user-supplied mean vector (vector of model coefficients).
Currently ignored.}

\item{sigma}{matrix; user-supplied covariance matrix for \code{mu}. Currently
ignored.}

\item{n_cores}{integer; number of CPU cores to use when generating
multivariate normal distributed random values. Only used if
\code{mvn_method = "mvnfast"} \strong{and} \code{method = "gaussian"}.}

\item{burnin}{numeric; the length of any initial burn in period to discard.
See \code{mgcv::gam.mh()}.}

\item{thin}{numeric; retain only \code{thin} samples. See \code{mgcv::gam.mh()}.}

\item{t_df}{numeric; degrees of freedom for static multivariate \emph{t} proposal.
See \code{mgcv::gam.mh()}.}

\item{rw_scale}{numeric; factor by which to scale posterior covariance
matrix when generating random walk proposals. See \code{mgcv::gam.mh()}.}

\item{index}{numeric; vector of indices of coefficients to use. Can be used
to subset the mean vector and covariance matrix extracted from \code{model}.}

\item{frequentist}{logical; if \code{TRUE}, the frequentist covariance matrix of
the parameter estimates is used. If \code{FALSE}, the Bayesian posterior
covariance matrix of the parameters is used. See \code{mgcv::vcov.gam()}.}

\item{unconditional}{logical; if \code{TRUE}  the Bayesian smoothing parameter
uncertainty corrected covariance matrix is used, \emph{if available} for
\code{model}. See \code{mgcv::vcov.gam()}.}

\item{parametrized}{logical; use parametrized coefficients and covariance
matrix, which respect the linear inequality constraints of the model. Only
for \code{scam::scam()} model fits.}

\item{mvn_method}{character; one of \code{"mvnfast"} or \code{"mgcv"}. The default is
uses \code{mvnfast::rmvn()}, which can be considerably faster at generate large
numbers of MVN random values than \code{mgcv::rmvn()}, but which might not work
for some marginal fits, such as those where the covariance matrix is close
to singular.}

\item{draws}{matrix; user supplied posterior draws to be used when
\code{method = "user"}.}

\item{seed}{numeric; the random seed to use. If \code{NULL}, a random seed will
be generated without affecting the current state of R's RNG.}
}
\description{
Low-level Functions to generate draws from the posterior distribution of
model coefficients

Generate posterior draws from a fitted model
}
