% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_utils.R
\name{rphi2x}
\alias{rphi2x}
\alias{x2rphi}
\alias{rtheta}
\alias{dtheta}
\alias{KLD10}
\alias{theta2H}
\title{Functions for the mapping between spherical and
Euclidean coordinates.}
\usage{
rphi2x(rphi)

x2rphi(x)

rtheta(n, lambda = 1, R, theta.base)

dtheta(theta, lambda, theta.base, H.elements)

KLD10(C1, C0)

theta2H(theta)
}
\arguments{
\item{rphi}{numeric vector where the first element
is the radius and the remaining are the angles}

\item{x}{parameters in the Euclidian space to be converted}

\item{n}{integer to define the size of the correlation matrix}

\item{lambda}{numeric as the parameter for the
Exponential distribution of the radius}

\item{R}{scaling matrix (square root of the Hessian
around the base model)}

\item{theta.base}{numeric vector of the base model}

\item{theta}{numeric vector of length \code{m}.}

\item{H.elements}{list output of theta2H}

\item{C1}{is a correlation matrix.}

\item{C0}{is a correlation matrix of the base model.}
}
\description{
Functions for the mapping between spherical and
Euclidean coordinates.
}
\details{
see \href{https://en.wikipedia.org/wiki/N-sphere}{N-sphere/Euclidian}

compute C1 using 'theta2C' on theta  with
\deqn{KLD = 0.5( tr(C0^{-1}C1) -p + ... - log(|C1|) + log(|C0|) )}
}
\section{Functions}{
\itemize{
\item \code{x2rphi()}: Tranform from Euclidian coordinates to spherical

\item \code{rtheta()}: Drawn samples from the PC-prior for correlation

\item \code{dtheta()}: PC-prior density for the correlation matrix

\item \code{KLD10()}: Compute the KLD with respect to a base model

\item \code{theta2H()}: Compute the hessian, its svd and some elements

}}
