% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R, R/stress_function.R
\name{layout_igraph_stress}
\alias{layout_igraph_stress}
\alias{stress_layout}
\alias{layout_with_stress}
\title{Stress majorization graph layout}
\usage{
layout_igraph_stress(g, iter = 500, tol = 1e-04, mds = TRUE,
  bbox = 50, circular)

layout_with_stress(g, iter = 500, tol = 1e-04, mds = TRUE,
  bbox = 50)
}
\arguments{
\item{g}{igraph object}

\item{iter}{number of iterations}

\item{tol}{stopping criterion}

\item{mds}{should an MDS layout be used as initial layout (default: TRUE)}

\item{bbox}{constrain dimension of output}

\item{circular}{not used}
}
\value{
coordinates to be used layouting a graph
}
\description{
Stress majorization graph layout
}
\details{
the layout_igraph_* function should not be used directly. It is only used as an argument for 'ggraph'.
}
\examples{
library(igraph)
library(ggraph)
set.seed(665)

g <- sample_pa(100,1,1,directed = FALSE)

#calculate layout manualy
xy <- layout_with_stress(g)
#use it with ggraph
ggraph(g,layout="stress")+
  geom_edge_link(width=0.2,colour="grey")+
  geom_node_point(col="black",size=0.3)+
  theme_graph()
}
\references{
Gansner, E. R., Koren, Y., & North, S. (2004). Graph drawing by stress majorization. In International Symposium on Graph Drawing (pp. 239-250). Springer, Berlin, Heidelberg.
}
