% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_weights.R
\name{adjust_weights_parametric}
\alias{adjust_weights_parametric}
\alias{adjust_weights_simes}
\title{Calculate adjusted hypothesis weights}
\usage{
adjust_weights_parametric(
  matrix_weights,
  matrix_intersections,
  test_corr,
  alpha,
  test_groups,
  maxpts = 25000,
  abseps = 1e-06,
  releps = 0
)

adjust_weights_simes(matrix_weights, p, test_groups)
}
\arguments{
\item{matrix_weights}{(Optional) A matrix of hypothesis weights of all
intersection hypotheses. This can be obtained as the second half of columns
from the output of \code{\link[=graph_generate_weights]{graph_generate_weights()}}.}

\item{matrix_intersections}{(Optional) A matrix of hypothesis indicators of
all intersection hypotheses. This can be obtained as the first half of
columns from the output of \code{\link[=graph_generate_weights]{graph_generate_weights()}}.}

\item{test_corr}{(Optional) A numeric matrix of correlations between test
statistics, which is needed to perform parametric tests using
\code{\link[=adjust_weights_parametric]{adjust_weights_parametric()}}. The number of rows and columns of
this correlation matrix should match the length of \code{p}.}

\item{alpha}{(Optional) A numeric value of the overall significance level,
which should be between 0 & 1. The default is 0.025 for one-sided
hypothesis testing problems; another common choice is 0.05 for two-sided
hypothesis testing problems. Note when parametric tests are used, only
one-sided tests are supported.}

\item{test_groups}{(Optional) A list of numeric vectors specifying hypotheses
to test together. Grouping is needed to correctly perform Simes and
parametric tests.}

\item{maxpts}{(Optional) An integer scalar for the maximum number of function
values, which is needed to perform parametric tests using the
\code{mvtnorm::GenzBretz} algorithm. The default is 25000.}

\item{abseps}{(Optional) A numeric scalar for the absolute error tolerance,
which is needed to perform parametric tests using the \code{mvtnorm::GenzBretz}
algorithm. The default is 1e-6.}

\item{releps}{(Optional) A numeric scalar for the relative error tolerance
as double, which is needed to perform parametric tests using the
\code{mvtnorm::GenzBretz} algorithm. The default is 0.}

\item{p}{(Optional) A numeric vector of p-values (unadjusted, raw), whose
values should be between 0 & 1. The length should match the number of
columns of \code{matrix_weights}.}
}
\value{
\itemize{
\item \code{\link[=adjust_weights_parametric]{adjust_weights_parametric()}} returns a matrix with the same
dimensions as \code{matrix_weights}, whose hypothesis weights have been
adjusted according to parametric tests.
\item \code{\link[=adjust_weights_simes]{adjust_weights_simes()}} returns a matrix with the same
dimensions as \code{matrix_weights}, whose hypothesis weights have been
adjusted according to Simes tests.
}
}
\description{
An intersection hypothesis can be rejected if its p-values are less than or
equal to their adjusted significance levels, which are their adjusted
hypothesis weights times \eqn{\alpha}. For Bonferroni tests, their adjusted
hypothesis weights are their hypothesis weights of the intersection
hypothesis. Additional adjustment is needed for parametric and Simes tests:
\itemize{
\item Parametric tests for \code{\link[=adjust_weights_parametric]{adjust_weights_parametric()}},
\itemize{
\item Note that one-sided tests are required for parametric tests.
}
\item Simes tests for \code{\link[=adjust_weights_simes]{adjust_weights_simes()}}.
}
}
\examples{
alpha <- 0.025
p <- c(0.018, 0.01, 0.105, 0.006)
num_hyps <- length(p)
g <- bonferroni_holm(rep(1 / 4, 4))
weighting_strategy <- graph_generate_weights(g)
matrix_intersections <- weighting_strategy[, seq_len(num_hyps)]
matrix_weights <- weighting_strategy[, -seq_len(num_hyps)]

set.seed(1234)
adjust_weights_parametric(
  matrix_weights = matrix_weights,
  matrix_intersections = matrix_intersections,
  test_corr = diag(4),
  alpha = alpha,
  test_groups = list(1:4)
)
alpha <- 0.025
p <- c(0.018, 0.01, 0.105, 0.006)
num_hyps <- length(p)
g <- bonferroni_holm(rep(1 / 4, 4))
weighting_strategy <- graph_generate_weights(g)
matrix_intersections <- weighting_strategy[, seq_len(num_hyps)]
matrix_weights <- weighting_strategy[, -seq_len(num_hyps)]

adjust_weights_simes(
  matrix_weights = matrix_weights,
  p = p,
  test_groups = list(1:4)
)
}
\references{
Lu, K. (2016). Graphical approaches using a Bonferroni mixture of weighted
Simes tests. \emph{Statistics in Medicine}, 35(22), 4041-4055.

Xi, D., Glimm, E., Maurer, W., and Bretz, F. (2017). A unified framework
for weighted parametric multiple test procedures.
\emph{Biometrical Journal}, 59(5), 918-931.
}
\seealso{
\code{\link[=adjust_p_parametric]{adjust_p_parametric()}} for adjusted p-values using parametric tests,
\code{\link[=adjust_p_simes]{adjust_p_simes()}} for adjusted p-values using Simes tests.
}
