% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-sf.R
\name{gh_as_sf}
\alias{gh_as_sf}
\alias{gh_as_sf.gh_route}
\alias{gh_as_sf.gh_spt}
\title{Convert a gh object into an sf object}
\usage{
gh_as_sf(data, ...)

\method{gh_as_sf}{gh_route}(data, ..., geom_type = c("linestring",
  "point"))

\method{gh_as_sf}{gh_spt}(data, ...)
}
\arguments{
\item{data}{A \code{gh_route} or \code{gh_spt} object.}

\item{...}{ignored}

\item{geom_type}{Use \code{geom_type = point} to return the points of the route
with ids corresponding to the instruction ids.}
}
\description{
Convert a gh object into an sf object
}
\examples{
\dontrun{
start_point <- c(52.592204, 13.414307)
end_point <- c(52.539614, 13.364868)

route <- gh_get_route(list(start_point, end_point)) \%>\%
  gh_as_sf()
}
}
