% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_to_df.R
\name{graph_to_df}
\alias{graph_to_df}
\title{Convert a graph into a edge list data.frame}
\usage{
graph_to_df(graph, weight = TRUE)
}
\arguments{
\item{graph}{A graph object of class \code{igraph}}

\item{weight}{Logical. If TRUE (default), then the column 'link' of the
output data.frame contains the weights of the links. If FALSE,
it contains only 0 and 1.}
}
\value{
An object of class \code{data.frame} with a link ID, the origin nodes
('from') and arrival nodes ('to') and the link
value ('link')(weighted or binary)
}
\description{
The function converts a graph into a edge list data.frame
}
\details{
The 'graph' nodes must have names. Links must have weights if
'weight = TRUE'.
}
\examples{
data(pts_pop_ex)
suppressWarnings(mat_geo <- mat_geo_dist(pts_pop_ex,
                 ID = "ID",
                 x = "x",
                y = "y"))
g1 <- gen_graph_thr(mat_w = mat_geo,
                    mat_thr = mat_geo,
                    thr = 20000)
g1_df <- graph_to_df(g1,
                     weight = TRUE)
}
\author{
P. Savary
}
