% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatterviolin.R
\name{plot_scatterviolin}
\alias{plot_scatterviolin}
\title{Plot a scatter plot on a violin plot with two variables.}
\usage{
plot_scatterviolin(
  data,
  xcol,
  ycol,
  symsize = 2.5,
  symthick = 1,
  bwid = 0.1,
  bvthick = 1,
  b_alpha = 1,
  s_alpha = 1,
  v_alpha = 1,
  ColPal = "all_grafify",
  ColSeq = TRUE,
  ColRev = FALSE,
  jitter = 0,
  trim = TRUE,
  scale = "width",
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on quantitative Y axis. This should be a quantitative variable.}

\item{symsize}{size of dots relative to \code{binwidth} used by \code{geom_point}. Default set to 2.5, increase/decrease as needed.}

\item{symthick}{thickness of dot border (\code{stroke} parameter of \code{geom_point}), default set to 1.}

\item{bwid}{width of boxplots; default 0.2}

\item{bvthick}{thickness of both violin and boxplot lines; default 1.}

\item{b_alpha}{fractional opacity of boxplots, default set to 1 (i.e. maximum opacity & zero transparency). For white boxplots inside violins, set \code{b_alpha = 0}.}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency). Set \code{s_alpha = 0} to not show scatter plot.}

\item{v_alpha}{fractional opacity of violins, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{ColPal}{grafify colour palette to apply, default "all_grafify"; alternatives: "okabe_ito", "bright", "pale", "vibrant", "contrast", "muted" "dark", "light".}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour choice, default F (FALSE); can be set to T (TRUE).}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0 (i.e. aligned symbols). To reduce symbol overlap, try 0.1-0.3 or higher.}

\item{trim}{set whether tips of violin plot should be trimmed at high/low data. Default \code{trim = T}, can be changed to F.}

\item{scale}{set to "area" by default, can be changed to "count" or "width".}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_boxplot}, \code{ggplot2}\link{geom_point} or \code{ggplot2}\link{geom_violin}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, X and Y variables, and plots a graph with a scatter plot and violinplot using \code{ggplot}.
}
\details{
The function uses \code{\link[ggplot2]{geom_violin}}, \code{\link[ggplot2]{geom_boxplot}}  and \code{\link[ggplot2]{geom_point}} geometries.
Note that the \code{\link{geom_violin}} options are set as follows: \code{scale = "width"}. The \code{trim = T} set by default can be changed when calling the function.
The boxplot shows IQR and the median is marked with a thicker horizontal line, and whisker depicts 1.5*IQR.
The X variable is mapped to the \code{fill} aesthetic in both violin and symbols, and its colour can be changed using \code{ColPal} option.
Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} (logical TRUE/FALSE) decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

The size of symbols can be adjusted using \code{symsize} set to 1 by default.
Transparency of violins and symbols can be set independently with \code{v_alpha} and \code{s_alpha}, respectively.

Three types of plots are available for scatter/jitter symbols and either bars+SD, boxplot or violin plots: \code{\link{plot_scatterbar_sd}}, \code{\link{plot_scatterbox}} and \code{\link{plot_scatterviolin}}.
These are related to the three "dot" versions that use a different geometry for symbols: \code{\link{plot_dotbox}}, \code{\link{plot_dotbar_sd}} and \code{\link{plot_dotviolin}}.
}
\examples{

#plot without jitter
plot_scatterviolin(data = data_t_pdiff, 
xcol = Condition, ycol = Mass, 
symsize = 2, trim = FALSE)

#with jitter
plot_scatterviolin(data = data_t_pdiff, 
xcol = Condition, ycol = Mass, 
symsize = 2, trim = FALSE, jitter = 0.1)

#white boxplot and no symbols
plot_scatterviolin(data = data_t_pdiff, 
xcol = Condition, ycol = Mass, 
b_alpha = 0, s_alpha = 0,
symsize = 2, trim = FALSE, jitter = 0.1)


}
