% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dotviolin_sc.R
\name{plot_dotviolin_sc}
\alias{plot_dotviolin_sc}
\title{Plot a dotplot on a violin plot with two variables.}
\usage{
plot_dotviolin_sc(
  data,
  xcol,
  ycol,
  colour = "ok_orange",
  dotsize = 1.5,
  dotthick = 1,
  bvthick = 1,
  bwid = 0.2,
  b_alpha = 1,
  d_alpha = 1,
  v_alpha = 1,
  trim = TRUE,
  scale = "width",
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on quantitative Y axis. This should be a quantitative variable.}

\item{colour}{colour of boxes and dots; a number between 1-64, any hexcode or names from \code{grafify} colour palettes. Default is \code{ok_orange}.}

\item{dotsize}{size of dots relative to \code{binwidth} used by \code{geom_dotplot}. Default set to 1.5, increase/decrease as needed.}

\item{dotthick}{thickness of dot border (\code{stroke} parameter of \code{geom_dotplot}), default set to 1.}

\item{bvthick}{thickness of violin an boxplot lines; default 1.}

\item{bwid}{width of boxplots; default 0.2}

\item{b_alpha}{fractional opacity of violins, default set to 1 (i.e. maximum opacity & zero transparency). For white boxplots inside violins, set \code{b_alpha = 0}.}

\item{d_alpha}{fractional opacity of dots, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{v_alpha}{fractional opacity of violins, default set to 1 (i.e. maximum opacity & zero transparency)}

\item{trim}{set whether tips of violin plot should be trimmed at high/low data. Default \code{trim = T}, can be changed to F.}

\item{scale}{set to "area" by default, can be changed to "count" or "width".}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_boxplot}, \code{ggplot2}\link{geom_dotplot} or \code{ggplot2}\link{geom_violin}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function is related to \code{plot_dotviolin}, but this one maps a single or same colour, therefore \verb{_sc}.
The only new argument is \code{colour}, which can be any hexcode or name of colours in the \code{all_grafify} \href{https://grafify-vignettes.netlify.app/colour_palettes.html#full-list-of-hexcodes}{palette}.
The default colour is \code{ok_orange}. \code{ColPal} and \code{ColRev} arguments are not available. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\examples{

#plot with trim = FALSE
plot_dotviolin_sc(data = data_1w_death, 
xcol = Genotype, ycol = Death, 
scale = "width", trim = FALSE)
#white boxplots
plot_dotviolin_sc(data = data_1w_death, 
xcol = Genotype, ycol = Death, colour = "light_orange", 
scale = "width", trim = FALSE, b_alpha = 0)

}
