% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar_sd_sc.R
\name{plot_bar_sd_sc}
\alias{plot_bar_sd_sc}
\title{Plot a bar graph indicating mean with error bars (SD) using two variables.}
\usage{
plot_bar_sd_sc(
  data,
  xcol,
  ycol,
  colour = "ok_orange",
  b_alpha = 1,
  bwid = 0.7,
  bthick = 1,
  ewid = 0.3,
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. a data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on the Y axis. This should be a quantitative variable.}

\item{colour}{colour of boxes and dots; a number between 1-64, any hexcode or names from. \code{grafify} colour palettes. Default is \code{ok_orange}.}

\item{b_alpha}{fractional opacity of bars, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{bwid}{width of bars (default 0.7).}

\item{bthick}{thickness of bar borders; default 1.}

\item{ewid}{width of error bars, default 0.3.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{stat_summary}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function is related to \code{\link{plot_bar_sd}}, but this one maps a single or same colour, therefore \verb{_sc}.
The only new argument is \code{colour}, which can be any hexcode or name of colours in the \code{all_grafify} \href{https://grafify-vignettes.netlify.app/colour_palettes.html#full-list-of-hexcodes}{palette}.
The default colour is \code{ok_orange}. \code{ColPal} and \code{ColRev} arguments are not available. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\details{
You are instead encouraged to show all data using the following functions: \code{\link{plot_scatterbar_sd}}, \code{\link{plot_scatterbox}}, \code{\link{plot_dotbox}}, \code{\link{plot_dotbar_sd}}, \code{\link{plot_scatterviolin}} or \code{\link{plot_dotviolin}}.
}
\examples{
plot_bar_sd_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time, 
colour = "ok_grey")

}
