% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gquad.R
\name{gquad}
\alias{gquad}
\title{Predicting G quadruplex motif(s)}
\usage{
gquad(x, xformat = "default")
}
\arguments{
\item{x}{nucleotide sequence(s) in raw format or a fasta file or a GenBank accession number(s); from which G quadruplex motif(s) will be predicted.
If the fasta file name does not contain an absolute path, the file name is relative to the current working directory.}

\item{xformat}{a character string specifying the format of x : default (raw), fasta, GenBank accession number(s).}
}
\value{
A dataframe of G quadruplex motif(s) position, sequence and length. If more than one nucleotide sequence is provided as argument, an input ID is returned for motif(s) predicted from each input sequence.
}
\description{
This function predicts G quadruplex motif(s)
in 'x' (nucleotide sequence(s)). Nucleotide sequence can be provided in raw or fasta format or as GenBank accession number(s).
Internet is needed to connect to GenBank database, if accession number(s) is given as argument.
}
\details{
This function predicts G quadruplex motif(s) in nucleic (both DNA and RNA) sequences and provide the position, sequence and length of the predicted motif(s), if any.
}
\examples{
## Predicting G quadruplex motif(s) from raw nucleotide sequences
E1 <- c("TCTTGGGCATCTGGAGGCCGGAAT", "taggtgctgggaggtagagacaggatatcct")
gquad(E1)

## Predicting G quadruplex motif(s) from nucleotide sequences in fasta file
## Not run: gquad(x="Example.fasta", xformat = "fasta")

## Predicting G quadruplex motif(s) from nucleotide sequences,
## using GenBank accession numbers.
## Internet connectivity is needed for this to work.
## Not run: gquad(c("BH114913", "AY611035"), xformat = "GenBank accession number(s)")
}
\author{
Hannah O. Ajoge
}
\references{
paper under review
}
\seealso{
gquadO
}

