% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-contents.R
\name{gpkg_add_contents}
\alias{gpkg_add_contents}
\alias{gpkg_update_contents}
\alias{gpkg_delete_contents}
\alias{gpkg_create_contents}
\title{Add, Remove, Update and Create \code{gpkg_contents} table and records}
\usage{
gpkg_add_contents(
  x,
  table_name,
  description = "",
  template = NULL,
  query_string = FALSE
)

gpkg_update_contents(x)

gpkg_delete_contents(x, table_name, query_string = FALSE)

gpkg_create_contents(x, query_string = FALSE)
}
\arguments{
\item{x}{A \emph{geopackage}}

\item{table_name}{Name of table to add or remove record for in \emph{gpkg_contents}}

\item{description}{Default \code{""}}

\item{template}{Default \code{NULL} uses global EPSG:4326 with bounds -180,-90:180,90}

\item{query_string}{\emph{logical}. Return SQLite statement rather than executing it? Default: \code{FALSE}}
}
\value{
logical. TRUE on successful execution of SQL statements.
}
\description{
\code{gpkg_add_contents()}: Add a record to \code{gpkg_contents}

\code{gpkg_update_contents()}: Add and remove \code{gpkg_contents} records to match existing tables

\code{gpkg_delete_contents()}: Delete a record from \code{gpkg_contents} based on table name

\code{gpkg_create_contents()}: Create an empty \code{gpkg_contents} table
}
