% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.plot.importance.R
\name{gpb.plot.importance}
\alias{gpb.plot.importance}
\title{Plot feature importance as a bar graph}
\usage{
gpb.plot.importance(tree_imp, top_n = 10L, measure = "Gain",
  left_margin = 10L, cex = NULL)
}
\arguments{
\item{tree_imp}{a \code{data.table} returned by \code{\link{gpb.importance}}.}

\item{top_n}{maximal number of top features to include into the plot.}

\item{measure}{the name of importance measure to plot, can be "Gain", "Cover" or "Frequency".}

\item{left_margin}{(base R barplot) allows to adjust the left margin size to fit feature names.}

\item{cex}{(base R barplot) passed as \code{cex.names} parameter to \code{\link[graphics]{barplot}}.
Set a number smaller than 1.0 to make the bar labels smaller than R's default and values
greater than 1.0 to make them larger.}
}
\value{
The \code{gpb.plot.importance} function creates a \code{barplot}
and silently returns a processed data.table with \code{top_n} features sorted by defined importance.
}
\description{
Plot previously calculated feature importance: Gain, Cover and Frequency, as a bar graph.
}
\details{
The graph represents each feature as a horizontal bar of length proportional to the defined importance of a feature.
Features are shown ranked in a decreasing importance order.
}
\examples{
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)

params <- list(
    objective = "binary"
    , learning_rate = 0.1
    , min_data_in_leaf = 1L
    , min_sum_hessian_in_leaf = 1.0
)

model <- gpb.train(
    params = params
    , data = dtrain
    , nrounds = 5L
)

tree_imp <- gpb.importance(model, percentage = TRUE)
gpb.plot.importance(tree_imp, top_n = 5L, measure = "Gain")
}
