% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-grafos-NPdif.R
\encoding{UTF-8}
\name{build_cover_random}
\alias{build_cover_random}
\title{Random vertex covers}
\usage{
build_cover_random(G, N, p = 0.75)
}
\arguments{
\item{G}{Graph.}

\item{N}{Number of random vertex set to try.}

\item{p}{Probability of each element to be selected.}
}
\value{
A list with four components: $set contains the subset of
V(g) representing the cover and $size contains the number of
vertices of the cover; $found is the number of vertex covers
found and $failed is the number of generated subset that were
not vertex covers.
}
\description{
Random algorithm for vertex-cover.
}
\details{
It builds N random vertex sets by inserting elements with
probability p, and it verifies if the subset so chosen is a
vertex cover by running \link{is_cover} on it.  It is very
difficult to find a good vertex cover in this way, so this
algorithm is very inefficient and it finds no specially good
covers.

Currently, this function is \emph{not} exported.  The random sampling
performed by \link{search_cover_random} is faster and more
efficient.
}
\examples{
n <- 25
g <- sample_gnp(n, p=0.25)  # Random graph
X5 <- build_cover_random(g,10000,p=0.65)
X5$size            # 19
plot_cover(X5, g)
X6 <- improve_cover_flip(g, X5)   # Improved : 17
plot_cover(X6, g)

}
\author{
Cesar Asensio
}
