% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goose_essentials.R
\name{goose_loop_me}
\alias{goose_loop_me}
\title{Convert Code to Loop Structure}
\usage{
goose_loop_me(code, loop_over, iterator_name = "i", parallel = FALSE)
}
\arguments{
\item{code}{Character string or file path containing the code to loop}

\item{loop_over}{What to loop over (e.g., "files", "columns", "rows", "list elements")}

\item{iterator_name}{Name for the loop variable (default: "i")}

\item{parallel}{Whether to use parallel processing (default: FALSE)}
}
\value{
Modified code with loop structure
}
\description{
Takes a script or code block and converts it to an efficient loop structure
based on the specified iteration requirements.
}
\examples{
\dontrun{
# Convert file processing to loop
code <- "data <- read.csv('file.csv')\nsummary(data)"
goose_loop_me(code, loop_over = "files")

# Create parallel loop
goose_loop_me("process_data(df)", loop_over = "datasets", parallel = TRUE)
}

}
