% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layers.R
\name{add_circles}
\alias{add_circles}
\title{Add circle}
\usage{
add_circles(map, data = get_map_data(map), id = NULL, lat = NULL,
  lon = NULL, radius = NULL, draggable = NULL, stroke_colour = NULL,
  stroke_opacity = NULL, stroke_weight = NULL, fill_colour = NULL,
  fill_opacity = NULL, mouse_over = NULL, mouse_over_group = NULL,
  info_window = NULL, layer_id = NULL, z_index = NULL)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data frame containing at least two columns, one specifying the
latitude coordinates, and the other specifying the longitude. If Null, the
data passed into \code{google_map()} will be used.}

\item{id}{string specifying the column containing an identifier for a circle}

\item{lat}{string specifying the column of \code{data} containing the 'latitude'
coordinates. If left NULL, a best-guess will be made}

\item{lon}{string specifying the column of \code{data} containing the 'longitude'
coordinates. If left NULL, a best-guess will be made}

\item{radius}{either a string specifying the column of \code{data} containing the
radius of each circle, OR a numeric value specifying the radius of all the circles
(radius is expressed in metres)}

\item{draggable}{string specifying the column of \code{data} defining if the circle
is 'draggable' (either TRUE or FALSE)}

\item{stroke_colour}{either a string specifying the column of \code{data} containing
the stroke colour of each circle, or a valid hexadecimal numeric HTML style to
be applied to all the circles}

\item{stroke_opacity}{either a string specifying the column of \code{data} containing
the stroke opacity of each circle, or a value between 0 and 1 that will be
applied to all the circles}

\item{stroke_weight}{either a string specifying the column of \code{data} containing
the stroke weight of each circle, or a number indicating the width of pixels
in the line to be applied to all the circles}

\item{fill_colour}{either a string specifying the column of \code{data} containing
the fill colour of each circle, or a valid hexadecimal numeric HTML style to
be applied to all the cirlces}

\item{fill_opacity}{either a string specifying the column of \code{data} containing
the fill opacity of each circle, or a value between 0 and 1 that will be applied to all the circles}

\item{mouse_over}{string specifying the column of data to display when the
mouse rolls over the circle}

\item{mouse_over_group}{string specifying the column of data specifying which
groups of circles to highlight on mouseover}

\item{info_window}{string specifying the column of data to display in an info
window when a circle is clicked}

\item{layer_id}{single value specifying an id for the layer.
layer.}

\item{z_index}{single value specifying where the circles appear in the layering
of the map objects. Layers with a higher \code{z_index} appear on top of those with
a lower \code{z_index}. See details.}
}
\description{
Add circles to a google map
}
\details{
\code{z_index} values define the order in which objects appear on the map.
Those with a higher value appear on top of those with a lower value. The default
order of objects is (1 being underneath all other objects)

\itemize{
  \item{1. Polygon}
  \item{2. Rectangle}
  \item{3. Polyline}
  \item{4. Circle}
}

Markers are always the top layer
}
\examples{
\dontrun{

google_map(key = map_key, data = tram_stops) \%>\%
 add_circles(lat = "stop_lat", lon = "stop_lon")

 }
}

