% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_make_png.R
\name{gt_make_png}
\alias{gt_make_png}
\title{Make Google Traffic PNG}
\usage{
gt_make_png(
  location,
  height,
  width,
  zoom,
  out_filename,
  google_key,
  webshot_delay = NULL,
  print_progress = TRUE
)
}
\arguments{
\item{location}{Vector of latitude and longitude}

\item{height}{Height (in pixels; pixel length depends on zoom)}

\item{width}{Width (in pixels; pixel length depends on zoom)}

\item{zoom}{Zoom level; integer from 0 to 20. For more information about how zoom levels correspond to pixel size, see \href{https://wiki.openstreetmap.org/wiki/Zoom_levels}{here}}

\item{out_filename}{Filename of PNG file to make}

\item{google_key}{Google API key}

\item{webshot_delay}{How long to wait for Google traffic layer to render. Larger height/widths require longer delay times. If \code{NULL}, the following delay time (in seconds) is used: \code{delay = max(height,width)/200}.}

\item{print_progress}{Whether to print function progress (default: \code{TRUE})}
}
\value{
Returns a georeferenced raster file. The file can contain the following values: 1 = no traffic; 2 = light traffic; 3 = moderate traffic; 4 = heavy traffic.
}
\description{
Make a png file of Google traffic data. The \code{\link[=gt_load_png_as_traffic_raster]{gt_load_png_as_traffic_raster()}} function can then
be used to convert the png into a traffic raster
}
\examples{
\dontrun{
gt_make_png(location     = c(40.712778, -74.006111),
            height       = 1000,
            width        = 1000,
            zoom         = 16,
            out_filename = "google_traffic.png",
            google_key   = "GOOGLE-KEY-HERE")
}

}
