% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_generate.R
\name{request_generate}
\alias{request_generate}
\title{Generate a Google Sheets API request}
\usage{
request_generate(
  endpoint = character(),
  params = list(),
  key = NULL,
  token = gs4_token()
)
}
\arguments{
\item{endpoint}{Character. Nickname for one of the selected Sheets API v4
endpoints built into googlesheets4. Learn more in \code{\link[=gs4_endpoints]{gs4_endpoints()}}.}

\item{params}{Named list. Parameters destined for endpoint URL substitution,
the query, or the body.}

\item{key}{API key. Needed for requests that don't contain a token. The need
for an API key in the absence of a token is explained in Google's document
\href{https://support.google.com/googleapi/answer/6158857?hl=en&ref_topic=7013279}{Credentials, access, security, and identity}.
In order of precedence, these sources are consulted: the formal \code{key}
argument, a \code{key} parameter in \code{params}, a user-configured API key set up
with \code{\link[=gs4_auth_configure]{gs4_auth_configure()}} and retrieved with \code{\link[=gs4_api_key]{gs4_api_key()}}.}

\item{token}{Set this to \code{NULL} to suppress the inclusion of a token. Note
that, if auth has been de-activated via \code{\link[=gs4_deauth]{gs4_deauth()}},
\code{gs4_token()} will actually return \code{NULL}.}
}
\value{
\code{list()}\cr Components are \code{method}, \code{url}, \code{body}, and \code{token},
suitable as input for \code{\link[=request_make]{request_make()}}.
}
\description{
Generate a request, using knowledge of the \href{https://developers.google.com/sheets/api/}{Sheets API} from its \href{https://www.googleapis.com/discovery/v1/apis/sheets/v4/rest}{Discovery Document}. Use
\code{\link[=request_make]{request_make()}} to execute the request. Most users should, instead, use
higher-level wrappers that facilitate common tasks, such as reading or
writing worksheets or cell ranges. The functions here are intended for
internal use and for programming around the Sheets API.

\code{request_generate()} lets you provide the bare minimum of input.
It takes a nickname for an endpoint and:
\itemize{
\item Uses the API spec to look up the \code{method}, \code{path}, and \code{base_url}.
\item Checks \code{params} for validity and completeness with respect to the
endpoint. Uses \code{params} for URL endpoint substitution and separates
remaining parameters into those destined for the body versus the query.
\item Adds an API key to the query if and only if \code{token = NULL}.
}
}
\examples{
req <- request_generate(
  "sheets.spreadsheets.get",
  list(spreadsheetId = gs4_example("deaths")),
  key = "PRETEND_I_AM_AN_API_KEY",
  token = NULL
)
req
}
\seealso{
\code{\link[gargle:request_develop]{gargle::request_develop()}}, \code{\link[gargle:request_develop]{gargle::request_build()}},
\code{\link[gargle:request_make]{gargle::request_make()}}

Other low-level API functions: 
\code{\link{gs4_has_token}()},
\code{\link{gs4_token}()},
\code{\link{request_make}()}
}
\concept{low-level API functions}
