% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces.R
\name{gtm_workspaces_submit}
\alias{gtm_workspaces_submit}
\title{Create a new container version}
\usage{
gtm_workspaces_submit(
  account_id,
  container_id,
  workspace_id,
  name,
  notes = NULL
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{name}{Version Name}

\item{notes}{Version Notes}
}
\description{
This creates a new version of the GTM container, but does not publish it
as a live version. The name and notes will be permanently visible for the container version.
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 6
name <- 'New Analytics Tags'
notes <- 'Adding element visibility tags and scroll tracking'

workspace <- gtm_workspaces_update(accountId, containerId, workspaceId, name, notes)

}


}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/create_version}

Other workspace functions: 
\code{\link{gtm_workspaces_create}()},
\code{\link{gtm_workspaces_delete}()},
\code{\link{gtm_workspaces_get}()},
\code{\link{gtm_workspaces_list}()},
\code{\link{gtm_workspaces_preview}()},
\code{\link{gtm_workspaces_resolve}()},
\code{\link{gtm_workspaces_status}()},
\code{\link{gtm_workspaces_sync}()},
\code{\link{gtm_workspaces_update}()}
}
\concept{workspace functions}
