% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshots.R
\name{snapshots_create}
\alias{snapshots_create}
\title{Creates a snapshot from the requested subscription}
\usage{
snapshots_create(name, subscription, labels = NULL)
}
\arguments{
\item{name}{\code{Snapshot}, \code{character} Required, an instance of a \code{Snapshot} object or a
snapshot name}

\item{subscription}{\code{Subscription}, \code{character} Required, an instance of a \code{Subscription}
object or a subscription name}

\item{labels}{\code{list} Key-value pairs for snapshot labels}
}
\value{
An instance of a \code{Snapshot} object
}
\description{
Snapshots are used in \href{https://cloud.google.com/pubsub/docs/replay-overview}{Seek} operations,
which allow you to manage message acknowledgments in bulk. That is, you can set the
acknowledgment state of messages in an existing subscription to the state captured by a snapshot.
If the snapshot already exists, returns \code{ALREADY_EXISTS}. If the requested subscription doesn't
exist, returns \code{NOT_FOUND}. If the backlog in the subscription is too old -- and the resulting
snapshot would expire in less than 1 hour -- then \code{FAILED_PRECONDITION} is returned.
See also the \code{Snapshot.expire_time} field. If the name is not provided in the request,
the server will assign a random name for this snapshot on the same project as the subscription,
conforming to the \href{https://cloud.google.com/pubsub/docs/admin#resource_names}{resource name format}.
The generated name is populated in the returned Snapshot object. Note that for REST API requests, you must
}
\seealso{
Other Snapshot functions: 
\code{\link{snapshots_delete}()},
\code{\link{snapshots_exists}()},
\code{\link{snapshots_list}()},
\code{\link{snapshots_patch}()}
}
\concept{Snapshot functions}
