% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badger.R
\name{cr_deploy_badger}
\alias{cr_deploy_badger}
\alias{cr_build_logs_badger}
\title{Deploy a Cloud Run app to display build badges}
\usage{
cr_deploy_badger(
  badger_image = "gcr.io/hightowerlabs/badger:0.0.1",
  json = Sys.getenv("GAR_CLIENT_JSON"),
  region = cr_region_get()
)

cr_build_logs_badger(dir = getwd(), projectId = cr_project_get())
}
\arguments{
\item{badger_image}{The docker image from the badger project to use}

\item{json}{The clientId JSON file of the project to create within}

\item{region}{The Cloud Run region}

\item{dir}{The directory containing the README.md file}

\item{projectId}{The projectId running the badger badge for a buildtrigger}
}
\description{
This uses \url{https://github.com/kelseyhightower/badger} to create badges you can display in README.md etc. showing the current status of a Cloud Build
}
\details{
\code{cr_build_logs_badger} is intended to be run from the root directory of
an R package that holds a README.md file containing a \code{![Cloudbuild]}
badge as created by \code{cr_deploy_badger()}.  The function will scan the
README.md file for the correct triggerId to pass to \link{cr_buildtrigger_logs}
}
