% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_sources.R
\name{cr_build_upload_gcs}
\alias{cr_build_upload_gcs}
\alias{cr_buildstep_source_move}
\title{Create a StorageSource}
\usage{
cr_build_upload_gcs(
  local,
  remote = paste0(local, format(Sys.time(), "\%Y\%m\%d\%H\%M\%S"), ".tar.gz"),
  bucket = cr_bucket_get(),
  predefinedAcl = "bucketOwnerFullControl",
  deploy_folder = "deploy"
)

cr_buildstep_source_move(deploy_folder)
}
\arguments{
\item{local}{Local directory containing the Dockerfile etc. you wish to deploy}

\item{remote}{The name of the folder in your bucket}

\item{bucket}{The Google Cloud Storage bucket to upload to}

\item{predefinedAcl}{The ACL rules for the object uploaded. Set to "bucketLevel" for buckets with bucket level access enabled}

\item{deploy_folder}{Which folder to deploy from - this will mean the files uploaded will be by default in \code{/workspace/deploy/}}
}
\value{
A Source object
}
\description{
This creates a \link{StorageSource} object after uploading to Google Cloud Storage
}
\details{
\code{cr_build_upload_gcs} copies the files into the \code{deploy_folder} in your working directory, then tars it for upload.  Files will be available on Cloud Build at \code{/workspace/deploy_folder/*}.

\code{cr_buildstep_source_move} is a way to move the StorageSource files in \code{/workspace/deploy_folder/*} into the root \code{/workspace/*} location, which is more consistent with \link{RepoSource} objects or GitHub build triggers created using \link{cr_buildtrigger_repo}.  This means the same runtime code can run for both sources.
}
\examples{
\dontrun{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
my_gcs_source <- cr_build_upload_gcs("my_folder")
build1 <- cr_build("cloudbuild.yaml", source = my_gcs_source)
}
cr_buildstep_source_move("deploy")

}
\seealso{
Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_targets}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml_secrets}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
