% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_sources.R
\name{Source}
\alias{Source}
\title{Source Object}
\usage{
Source(storageSource = NULL, repoSource = NULL)
}
\arguments{
\item{storageSource}{If provided via \link{StorageSource}, get the source
from this location in Google Cloud Storage}

\item{repoSource}{If provided via \link{RepoSource}, get the source from
this location in a Cloud Source}
}
\value{
Source object
}
\description{
It is suggested to use \link{cr_build_source} instead to build sources
}
\details{
Location of the source in a supported storage service.
}
\examples{

cr_project_set("my-project")
cr_bucket_set("my-bucket")
my_gcs_source <- Source(storageSource=StorageSource("my_code.tar.gz",
                                                    "gs://my-bucket"))
my_repo_source <- Source(repoSource=RepoSource("https://my-repo.com",
                                               branchName="master"))

\dontrun{

build1 <- cr_build("cloudbuild.yaml", source = my_gcs_source)
build2 <- cr_build("cloudbuild.yaml", source = my_repo_source)

}
}
\seealso{
Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
