% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps.R
\name{cr_buildstep_extract}
\alias{cr_buildstep_extract}
\title{Extract a buildstep from a Build object}
\usage{
cr_buildstep_extract(x, step = NULL)
}
\arguments{
\item{x}{A \link{Build} object}

\item{step}{The numeric step number to extract}
}
\description{
Useful if you have a step from an existing cloudbuild.yaml you want in another
}
\examples{
package_build <- system.file("cloudbuild/cloudbuild.yaml",
                             package = "googleCloudRunner")
build <- cr_build_make(package_build)
build
cr_buildstep_extract(build, step = 1)
cr_buildstep_extract(build, step = 2)
}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
