% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-js-auth.R
\name{googleAuth_jsUI}
\alias{googleAuth_jsUI}
\title{Shiny JavaScript Google Authorisation [UI Module]}
\usage{
googleAuth_jsUI(
  id,
  login_class = "btn btn-primary",
  logout_class = "btn btn-danger",
  login_text = "Log In",
  logout_text = "Log Out",
  prompt = c("consent", "select_account", "both", "none"),
  scopes = getOption("googleAuthR.scopes.selected", "email")
)
}
\arguments{
\item{id}{Shiny id}

\item{login_class}{CSS class of login button}

\item{logout_class}{CSS class of logout button}

\item{login_text}{Text to show on login button}

\item{logout_text}{Text to show on logout button}

\item{prompt}{The type of login screen}

\item{scopes}{Set the scopes, minimum needs is "email"}
}
\value{
Shiny UI
}
\description{
A Javascript Google authorisation flow for Shiny apps.
}
\details{
Shiny Module for use with \link{googleAuth_js}
}
