% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{gar_auth_service}
\alias{gar_auth_service}
\title{JSON service account authentication}
\usage{
gar_auth_service(json_file, scope = getOption("googleAuthR.scopes.selected"))
}
\arguments{
\item{json_file}{the JSON file downloaded from Google Developer Console}

\item{scope}{Scope of the JSON file auth if needed}
}
\value{
(Invisible) Sets authentication token
}
\description{
As well as OAuth2 authentication, 
  you can authenticate without user interaction via Service accounts.  
  This involves downloading a secret JSON key with the authentication
  details.
  
  To use, go to your Project in 
    the https://console.developers.google.com/apis/credentials/serviceaccountkey
    
    and select JSON Key type.  Save the file 
  to your computer and call it via supplying 
  the file path to the \code{json_file} parameter.
  
  Navigate to it via: 
    Google Dev Console > Credentials > New credentials > Service account Key > 
       Select service account > Key type = JSON
}
\seealso{
https://developers.google.com/identity/protocols/OAuth2ServiceAccount

https://developers.google.com/identity/protocols/OAuth2ServiceAccount

Other authentication functions: \code{\link{gar_attach_auto_auth}},
  \code{\link{gar_auth}}, \code{\link{gar_auto_auth}},
  \code{\link{gar_gce_auth}},
  \code{\link{get_google_token}},
  \code{\link{token_exists}}
}
