% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_data.R
\name{defineGlobalAttribute}
\alias{defineGlobalAttribute}
\title{Define a global time-varying attribute}
\usage{
defineGlobalAttribute(global)
}
\arguments{
\item{global}{a data frame containing all the values this global attribute
takes along time.}
}
\value{
an object of class \code{global.goldfish}
}
\description{
This function allows to define a global attribute of the nodeset
(i.e a variable that is identical for each node but changes over time).
}
\details{
For instance, seasonal climate changes could be defined as a
changing global attribute.
Then, this global attribute can be linked to the nodeset by using
\code{\link[=linkEvents]{linkEvents()}}
}
\examples{
seasons <- defineGlobalAttribute(data.frame(time = 1:12, replace = 1:12))
}
