% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_data.R
\name{defineDependentEvents}
\alias{defineDependentEvents}
\title{Define dependent events for a model}
\usage{
defineDependentEvents(
  events,
  nodes,
  nodes2 = NULL,
  defaultNetwork = NULL,
  envir = environment()
)
}
\arguments{
\item{events}{a data frame containing the event list that should be
considered as a dependent variable in models.}

\item{nodes}{a data frame or a \code{nodes.goldfish} object containing the nodes
used in the event list.}

\item{nodes2}{a second nodeset in the case that the events occurs in a
two-mode network.}

\item{defaultNetwork}{the name of a \code{network.goldfish} object.}

\item{envir}{An \linkS4class{environment} object where the nodes-set
and default network objects are defined. The default value is
\code{\link[=environment]{environment()}}.}
}
\value{
an object with additional class \code{dependent.goldfish} with attributes:
\item{nodes}{a character vector with the names of the nodes set that define
the dimensions of the \code{defaultNetwork}. \code{nodes} and \code{nodes2} arguments.}
\item{defaultNetwork}{A character value with the name of the network object
when this is present. \code{defaultNetwork} argument.}
\item{type}{A character value that can take values monadic or dyadic
depending on the arguments used during the definition.}

The object can be modified using methods for data frames.
}
\description{
The final step in defining the data objects is to identify
the dependent events.
}
\details{
Before this step is performed, we have to define:
the nodeset (\code{\link[=defineNodes]{defineNodes()}}), the network (\code{\link[=defineNetwork]{defineNetwork()}})
and the link the event list to the network (\code{\link[=linkEvents]{linkEvents()}}).

During the definition as a dependent event, some checks are done to ensure
consistency with the default network and the nodeset.
In particular, consistency of the labels of nodes in the events with the
nodes' labels in the network and the nodeset is done.

It is possible to define as a dependent event a different set of events to
the ones link to the default network.
This is useful to model different type of events where the event dynamic is
driven by different effects or its weight differs.
\link{Fisheries_Treaties_6070} has an example of it, the relational event modeled
are fisheries treaties between countries. The \code{bilatchanges} data frame
contains information of creation and dissolution of treaties.
\code{vignette(teaching2)} shows how to model just the creation of treaties
conditional on creation and dissolution.
}
\examples{
actors <- data.frame(
  actor = 1:5, label = paste("Actor", 1:5),
  present = TRUE, gender = sample.int(2, 5, replace = TRUE)
)
actors <- defineNodes(nodes = actors)
calls <- data.frame(
  time = c(12, 27, 45, 56, 66, 68, 87),
  sender = paste("Actor", c(1, 3, 5, 2, 3, 4, 2)),
  receiver = paste("Actor", c(4, 2, 3, 5, 1, 2, 5)), increment = rep(1, 7)
)
callNetwork <- defineNetwork(nodes = actors)
callNetwork <- linkEvents(
  x = callNetwork, changeEvent = calls, nodes = actors
)

# Defining the dependent events:
callDependent <- defineDependentEvents(
  events = calls, nodes = actors, defaultNetwork = callNetwork
)
}
\seealso{
\code{\link[=defineNodes]{defineNodes()}}, \code{\link[=defineNetwork]{defineNetwork()}}, \code{\link[=linkEvents]{linkEvents()}}
}
