% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Variance_summary_stats.R
\name{var.summary}
\alias{var.summary}
\title{Variance summary statistics}
\usage{
var.summary(qt, x, iter_num = 50, eps_param = 1e-10)
}
\arguments{
\item{qt}{A numeric vector.}

\item{x}{A data frame, each column represents a covariate that should be numeric.}

\item{iter_num}{An integer. Represents the number of iterations performed in the Gauss-Newton algorithm}

\item{eps_param}{A number. The Gauss-Newton algorithm terminates if the incriment change of all variance estimates is smaller than this number.}
}
\value{
A list with the following objects:
* summary, a dataframe with a variance effect estimate for each variable and summary statistics
* chi2, the chi2 statistic obtained by considering all parameteres jointly
* df, degrees of freedom for the chi2 statistic
* pval, p-value of the model
* adjusted_values, a vector with qt values that have been adjusted for both mean and variance effects
}
\description{
Estimates the variance effect of several continuous variables jointly
}
\examples{
n_val <- 50000
x <- as.data.frame(matrix(0,nrow = n_val, ncol = 4))
colnames(x) <- c('A','B','C','D')
for(i in 1:4) {
x[, i] <- rnorm(n_val)
}
var_vec <- exp(0.2 * x[, 1] - 0.3 * x[, 4])
qt_vec <- rnorm(n_val, 0, sqrt(var_vec))
res <- var.summary(qt_vec, x)
}
