% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Histogram_by_genotype.R
\name{hist_by_gen}
\alias{hist_by_gen}
\title{Histogram by genotype}
\usage{
hist_by_gen(
  qt,
  g,
  bins = 100,
  trait_name = "qt trait",
  title = "",
  outlier_quantiles = c(0.025, 0.975),
  sd_lines = c(1, 1)
)
}
\arguments{
\item{qt}{A numeric vector.}

\item{g}{An integer vector.}

\item{bins}{An integer.}

\item{trait_name}{A string.}

\item{title}{A string.}

\item{outlier_quantiles}{A vector with length 2.}

\item{sd_lines}{A vector with length 2.}
}
\value{
A histgram plot
}
\description{
This tool creates three histogram plots. One per genotype. Additionally, outliers are colored red (by default subjects that are in the top and bottom 2.5% of the distribution)
and blue lines are added to indicate the mean and (by default) one standard deviation in each direction.
}
\examples{
n_val <- 50000L
geno_vec <- sample(c(0, 1, 2), size = n_val, replace = TRUE)
qt_vec <- rnorm(n_val) * (1.3^geno_vec) + 1 * geno_vec
hist_by_gen(qt_vec, geno_vec)
}
