% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avar.r
\name{avar}
\alias{avar}
\title{Calculate the Allan Variance}
\usage{
avar(x, type = "mo")
}
\arguments{
\item{x}{A \code{vec} containing the time series under observation.}

\item{type}{A \code{string} containing either \code{"mo"} for Maximal Overlap or \code{"to"} for Tau Overlap}
}
\value{
Allan variance fixed

av A \code{list} that contains:
\itemize{
 \item{"clusters"}{The size of the cluster}
 \item{"allan"}{The Allan variance}
 \item{"errors"}{The error associated with the variance estimation.}
}
}
\description{
Computes the Allan Variance
}
\details{
The decomposition and the amount of time it takes to perform it depends on whether you are using
the Tau Overlap or the Maximal Overlap.

Maximal Overlap Allan Variance
Given \eqn{N} equally spaced samples with averaging time \eqn{\tau = n\tau _0}{tau = n*tau_0},
where \eqn{n} is an integer such that \eqn{ 1 \le n \le \frac{N}{2}}{1<= n <= N/2}.
Therefore, \eqn{n} is able to be selected from \eqn{\left\{ {n|n < \left\lfloor {{{\log }_2}\left( N \right)} \right\rfloor } \right\}}{{n|n< floor(log2(N))}}
Then, \eqn{M = N - 2n} samples exist. 
The Maximal-overlap estimator is given by:
\eqn{\frac{1}{{2\left( {N - 2k + 1} \right)}}\sum\limits_{t = 2k}^N {{{\left[ {{{\bar Y}_t}\left( k \right) - {{\bar Y}_{t - k}}\left( k \right)} \right]}^2}} }

where \eqn{ {{\bar y}_t}\left( \tau  \right) = \frac{1}{\tau }\sum\limits_{i = 0}^{\tau  - 1} {{{\bar y}_{t - i}}} }.

Tau-Overlap Allan Variance
Given \eqn{N} equally spaced samples with averaging time \eqn{\tau = n\tau _0}{tau = n*tau_0},
where \eqn{n} is an integer such that \eqn{ 1 \le n \le \frac{N}{2}}{1<= n <= N/2}.
Therefore, \eqn{n} is able to be selected from \eqn{\left\{ {n|n < \left\lfloor {{{\log }_2}\left( N \right)} \right\rfloor } \right\}}{{n|n< floor(log2(N))}}
Then, a sampling of \eqn{m = \left\lfloor {\frac{{N - 1}}{n}} \right\rfloor  - 1} samples exist. 
The tau-overlap estimator is given by:

where \eqn{ {{\bar y}_t}\left( \tau  \right) = \frac{1}{\tau }\sum\limits_{i = 0}^{\tau  - 1} {{{\bar y}_{t - i}}} }.
}
\examples{
set.seed(999)
# Simulate white noise (P 1) with sigma^2 = 4
N = 100000
white.noise = rnorm(N, 0, 2)
#plot(white.noise,ylab="Simulated white noise process",xlab="Time",type="o")
#Simulate random walk (P 4)
random.walk = cumsum(0.1*rnorm(N, 0, 2))
combined.ts = white.noise+random.walk
av_mat = avar_mo_cpp(combined.ts)
}
\author{
JJB

JJB
}
\references{
Long-Memory Processes, the Allan Variance and Wavelets, D. B. Percival and P. Guttorp
}

