% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simData}
\alias{simData}
\title{Simulate data from a multivariate joint model}
\usage{
simData(
  n = 250,
  ntms = 10,
  fup = 5,
  family = list("gaussian", "gaussian"),
  sigma = c(0.16, 0.16),
  beta = rbind(c(1, 0.1, 0.33, -0.5), c(1, 0.1, 0.33, -0.5)),
  D = NULL,
  gamma = c(0.5, -0.5),
  zeta = c(0.05, -0.3),
  theta = c(-4, 0.2),
  cens.rate = exp(-3.5),
  random.formula = NULL,
  return.ranefs = FALSE
)
}
\arguments{
\item{n}{the number of subjects}

\item{ntms}{the number of time points}

\item{fup}{the maximum follow-up time, such that t = [0, ..., fup] with length \code{ntms}. 
In instances where subject \eqn{i} \emph{doesn't} fail before \code{fup}, their censoring
time is set as \code{fup + 0.1}.}

\item{family}{a \eqn{K}-list of families, see \strong{details}.}

\item{sigma}{a \eqn{K}-vector of dispersion parameters corresponding to the order of 
\code{family}; see \strong{details}.}

\item{beta}{a \eqn{K \times 4} matrix specifying fixed effects for each \eqn{K} parameter, 
in the order (Intercept), time, continuous, binary.}

\item{D}{a positive-definite matrix specifying the variance-covariance matrix for the random
effects. If not supplied an identity matrix is assumed.}

\item{gamma}{a \eqn{K}-vector specifying the association parameters for each longitudinal 
outcome.}

\item{zeta}{a vector of length 2 specifying the coefficients for the baseline covariates in 
the survival sub-model, in the order of continuous and binary.}

\item{theta}{parameters to control the failure rate, see \strong{baseline hazard}.}

\item{cens.rate}{parameter for \code{rexp} to generate censoring times for each subject.}

\item{random.formula}{allows user to specify if an intercept-and-slope (\code{~ time}) or 
intercept-only (\code{~1}) random effects structure should be used. defaults to the former.}

\item{return.ranefs}{a logical determining whether the \emph{true} random effects should be 
returned. This is largely for internal/simulation use. Default \code{return.ranefs = FALSE}.}
}
\value{
A list of two \code{data.frame}s: One with the full longitudinal data, and another 
with only survival data. If \code{return.ranefs=TRUE}, a matrix of the true \eqn{b} values is
also returned.
}
\description{
Simulate multivariate longitudinal and survival data from a joint model 
specification, with potential mixture of response families. Implementation is similar 
to existing packages (e.g. \code{joineR}, \code{joineRML}).
}
\details{
\code{simData} simulates data from a multivariate joint model with a mixture of 
families for each \eqn{K=1,\dots,3} response. Currently, the argument \code{random.formula}
specifies the association structure for \strong{all} responses. The specification of 
\code{family} changes requisite dispersion parameter, if applicable. The \code{family} list can
(currently) contain: 
  
  \describe{
 
  \item{\code{"gaussian"}}{Simulated with identity link, corresponding item in \code{sigma}
  will be the \strong{variance}.}
  \item{\code{"poisson"}}{Simulated with log link, corresponding dispersion in \code{sigma} 
  can be anything, as it doesn't impact simulation.}
  \item{\code{"binomial"}}{Simulated with logit link, corresponding dispersion in \code{sigma} 
  can be anything, as it doesn't impact simulation.}
  \item{\code{"genpois"}}{Simulated with a log link, corresponding item in \code{sigma} will be
  the \strong{dispersion}. Values < 0 correspond to under-dispersion, and values > 0 over-
  dispersion. See \code{\link{rgenpois}} for more information. Simulated variance is 
  \eqn{(1+\varphi)^2\mu}.}
  \item{\code{"Gamma"}}{Simulated with a log link, corresponding item in \code{sigma} will be
  the \strong{shape}.}
  
  }
}
\section{Baseline hazard}{
 
 
  When simulating the survival time, the baseline hazard is a Gompertz distribution controlled 
  by \code{theta=c(x,y)}:
  
  \deqn{\lambda_0(t) = \exp{x + yt}}
  
  where \eqn{y} is the shape parameter, and the scale parameter is \eqn{\exp{x}}.
}

\examples{

# K = 3 mixture of families with dispersion parameters
beta <- do.call(rbind, replicate(3, c(2, -0.1, 0.1, -0.2), simplify = FALSE))
gamma <- c(0.3, -0.3, 0.3)
D <- diag(c(0.25, 0.09, 0.25, 0.05, 0.25, 0.09))
family <- list('gaussian', 'genpois', 'Gamma')
sigma <- c(.16, 1.5, 1.5)
sim.data <- simData(ntms=15, family = family, sigma = sigma, beta = beta, D = D, gamma = gamma,
                    theta = c(-3, 0.2), zeta = c(0,-.2))

# K = 4 mixture of families with/out dispersion
beta <- do.call(rbind, replicate(4, c(2, -0.1, 0.1, -0.2), simplify = FALSE))
gamma <- c(-0.75, 0.3, -0.6, 0.5)
D <- diag(c(0.25, 0.09, 0.25, 0.05, 0.25, 0.09, 0.16, 0.02))
family <- list('gaussian', 'poisson', 'binomial', 'gaussian')
sigma <- c(.16, 0, 0, .05)
sim.data <- simData(ntms=15, family = family, sigma = sigma, beta = beta, D = D, gamma = gamma,
                    theta = c(-3, 0.2), zeta = c(0,-.2))
}
\references{
Austin PC. Generating survival times to simulate Cox proportional hazards
models with time-varying covariates. \emph{Stat Med.} 2012; \strong{31(29)}:
3946-3958.
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk}).
}
\keyword{simulation}
