% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backwardCompatibility.R
\name{predict.gmvar}
\alias{predict.gmvar}
\title{DEPRECATED! USE THE FUNCTION predict.gsmvar INSTEAD! Predict method for class 'gmvar' objects}
\usage{
\method{predict}{gmvar}(
  object,
  ...,
  n_ahead,
  n_simu = 2000,
  pi = c(0.95, 0.8),
  pi_type = c("two-sided", "upper", "lower", "none"),
  pred_type = c("median", "mean", "cond_mean"),
  plot_res = TRUE,
  mix_weights = TRUE,
  nt
)
}
\arguments{
\item{object}{an object of class 'gmvar'}

\item{...}{additional arguments passed to \code{grid} (ignored if \code{plot_res==FALSE}) which plots
grid to the figure.}

\item{n_ahead}{how many steps ahead should be predicted?}

\item{n_simu}{to how many independent simulations should the forecast be based on?}

\item{pi}{a numeric vector specifying the confidence levels of the prediction intervals.}

\item{pi_type}{should the prediction intervals be "two-sided", "upper", or "lower"?}

\item{pred_type}{should the prediction be based on sample "median" or "mean"? Or should it
be one-step-ahead forecast based on the exact conditional mean (\code{"cond_mean"})?
Prediction intervals won't be calculated if the exact conditional mean is used.}

\item{plot_res}{should the results be plotted?}

\item{mix_weights}{\code{TRUE} if forecasts for mixing weights should be plotted,
\code{FALSE} in not.}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the prediction (ignored if \code{plot_res==FALSE}). Default is \code{round(nrow(data)*0.15)}.}
}
\value{
Returns a class '\code{gsmvarpred}' object containing, among the specifications,...
 \describe{
   \item{$pred}{Point forecasts}
   \item{$pred_int}{Prediction intervals, as \code{[, , d]}.}
   \item{$mix_pred}{Point forecasts for the mixing weights}
   \item{mix_pred_int}{Individual prediction intervals for mixing weights, as \code{[, , m]}, m=1,..,M.}
 }
}
\description{
\code{predict.gsmvar} is a predict method for class \code{'gsmvar'} objects. The forecasts of
  the GMVAR model are computed by performing independent simulations and using the
  sample medians or means as point forecasts and empirical quantiles as prediction intervals.
  For one-step-ahead predictions using the exact conditional mean is also supported.
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2022. Structural Gaussian mixture vector autoregressive model with application to the asymmetric
     effects of monetary policy shocks. Unpublished working paper, available as arXiv:2007.04713.
   \item Virolainen S. 2022. Gaussian and Student's t mixture vector autoregressive model with application to the
     asymmetric effects of monetary policy shocks in the Euro area. Unpublished working
     paper, available as arXiv:2109.13648.
 }
 @keywords internal
}
\seealso{
\code{\link{predict.gsmvar}}
}
