% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMVARconstruction.R
\name{gmvar_to_sgmvar}
\alias{gmvar_to_sgmvar}
\title{Switch from two-regime reduced form GMVAR model to a structural GMVAR model.}
\usage{
gmvar_to_sgmvar(gmvar)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}
}
\value{
Returns an object of class \code{'gmvar'} defining a structural GMVAR model based on a
  two-regime reduced form GMVAR model with the main diagonal of the B-matrix normalized to be
  positive.
}
\description{
\code{gmvar_to_sgmvar} constructs SGMVAR model based on a reduced form GMVAR model.
}
\details{
The switch is made by simultaneously diagonalizing the two error term covariance matrices
  with a well known matrix decomposition (Muirhead, 1982, Theorem A9.9) and then normalizing the
  diagonal of the matrix W positive (which implies positive diagonal of the B-matrix). Models with
  more that two regimes are not supported because the matrix decomposition does not generally
  exists for more than two covariance matrices. If the model has only one regime (= regular SVAR model),
  a symmetric and pos. def. square root matrix of the error term covariance matrix is used.

  The columns of \eqn{W} as well as the lambda parameters can be re-ordered (without changing the implied
  reduced form model) afterwards with the function \code{reorder_W_columns}. Also all signs in any column
  of \eqn{W} can be swapped (without changing the implied reduced form model) afterwards with the function
  \code{swap_W_signs}. These two functions work with models containing any number of regimes.
}
\examples{
\donttest{
# These are long running examples
data(eurusd, package="gmvarkit")
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# Reduced form GMVAR(1,2) model
fit12 <- fitGMVAR(data, 1, 2, ncalls=1, seeds=3)

# Form a structural model based on the reduced form model:
mod12s <- gmvar_to_sgmvar(fit12)
}
}
\references{
\itemize{
   \item Muirhead R.J. 1982. Aspects of Multivariate Statistical Theory, \emph{Wiley}.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{GIRF}}, \code{\link{reorder_W_columns}},
 \code{\link{swap_W_signs}}
}
