% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAINest.R
\name{iterate_more}
\alias{iterate_more}
\title{Maximum likelihood estimation of GMVAR model with preliminary estimates}
\usage{
iterate_more(gmvar, maxit = 100)
}
\arguments{
\item{gmvar}{object of class \code{'gmvar'}, generated by function \code{fitGMVAR()} or \code{GMVAR()}.}

\item{maxit}{maximum number of iterations in the variable metric algorithm.}
}
\value{
Returns an object of class \code{'gmvar'} defining the estimated GMVAR model. Can be used
  to work with other functions provided in \code{gmvarkit}.
}
\description{
\code{iterate_more} uses variable metric algorithm to finalize maximum likelihood
 estimation of GMVAR model (object of class \code{'gmvar'}) which already has preliminary estimates.
}
\details{
The main purpose of \code{iterate_more()} is to provide a simple and convenient tool to finalize
  the estimation when the maximum number of iterations is reached when estimating a GMVAR model with the
  main estimation function \code{fitGMVAR()}. It's just a simple wrapper around function \code{optim()}
  from the package \code{stats} and \code{GMVAR()} from the package \code{gmvarkit}.
}
\examples{
\donttest{
## These are long running examples that use parallel computing!

# These examples use the data 'eurusd' which comes with the
# package, but in a scaled form.
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# GMVAR(1,2) model, only 5 iterations of the variable metric
# algorithm
fit12 <- fitGMVAR(data, p=1, M=2, maxit=5)
fit12

# Iterate more:
fit12_2 <- iterate_more(fit12)
fit12_2


# GMVAR(2,2) model with autoregressive parameters restricted
# to be the same for all regimes, only 10 iterations of the
# variable metric algorithm
C_mat <- rbind(diag(2*2^2), diag(2*2^2))
fit22c <- fitGMVAR(data, p=2, M=2, constraints=C_mat, maxit=10)
fit22c

# Iterate more:
fit22c_2 <- iterate_more(fit22c)
fit22c_2

# GMVAR(3,2) model, only 10 iterations of the variable metric
# algorithm
fit32 <- fitGMVAR(data, p=3, M=2, maxit=10)
fit32

# Iterate more:
fit32_2 <- iterate_more(fit32)
fit32_2
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
 }
}
\seealso{
\code{fitGMVAR()}, \code{GMVAR()}, \code{optim()}
}
