% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gng.R
\name{plot.Rcpp_GNGServer}
\alias{plot.Rcpp_GNGServer}
\title{plot GNG object}
\usage{
\method{plot}{Rcpp_GNGServer}(x, vertex.color = gng.plot.color.cluster,
  layout = layout.fruchterman.reingold, mode = gng.plot.2d,
  vertex.size = 3, ...)
}
\arguments{
\item{x}{GNG object}

\item{vertex.color}{How to color vertexes. Possible values: \code{"fast.cluster"} (vertex color is set to fastgreedy.community clustering),
\code{"label"} (rounds to integer label if present), \code{list of integers} (colors vertices according to provided list), \code{"none"} (every node is white),}

\item{layout}{igraph layout to be used when plotting. Defaults to \code{layout.fruchterman.reingold}.
Other good choice is using \code{gng.plot.layout.v2d}, which returns two first spatial coordinates.}

\item{mode}{\code{"2d"} (igraph plot)
\code{"2d.errors"} (igraph plot with mean error log plot)}

\item{vertex.size}{Size of plotted vertices}

\item{...}{other arguments not used by this method.}
}
\description{
Plot resulting graph using igraph plotting
}
\details{
Plot GNG
}
\note{
If you want to "power-use" plotting and plot for instance a subgraph, you might be interested in
exporting igraph with convertToIGraph function
}
\examples{
\dontrun{
gng <- GNG(scaled.wine)
# Plots igraph using first 2 coordinates and colors according to clusters
plot(gng, mode=gng.plot.2d.errors, layout=gng.plot.layout.v2d, vertex.color=gng.plot.color.cluster)

# For more possibilities see gng.plot.* constants
}
}

