% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gng.R
\name{GNG}
\alias{GNG}
\title{Constructor of GrowingNeuralGas object.}
\usage{
GNG(x = NULL, labels = c(), beta = 0.99, alpha = 0.5,
  max.nodes = 1000, eps.n = 6e-04, eps.w = 0.05, max.edge.age = 200,
  train.online = FALSE, max.iter = 200, dim = -1,
  min.improvement = 0.001, lambda = 200, verbosity = 0, seed = -1,
  k = NULL)
}
\arguments{
\item{x}{Passed data (matrix of data.frame) for offline training}

\item{labels}{Every example can be associated with labels that are added to nodes later. By default empty}

\item{beta}{Decrease the error variables of all node
nodes by this fraction (forgetting rate). Default 0.99}

\item{alpha}{Decrease the error variables of the nodes neighboring to
the newly inserted node by this fraction. Default 0.5}

\item{max.nodes}{Maximum number of nodes
(after reaching this size it will continue running, but won't add new nodes)}

\item{eps.n}{How strongly adapt neighbour node. Default \code{0.0006}}

\item{eps.w}{How strongly adapt winning node. Default \code{0.05}}

\item{max.edge.age}{Maximum edge age. Decrease to increase speed of change of graph topology. Default \code{200}}

\item{train.online}{default FALSE. If used will run in online fashion}

\item{max.iter}{Uf training offline will stop if exceedes max.iter iterations. Default \code{200}}

\item{dim}{Used for training online, specifies training example size}

\item{min.improvement}{Used for offline (default) training.
Controls stopping criterion, decrease if training stops too early. Default \code{1e-3}}

\item{lambda}{Every lambda iteration is added new vertex. Default 200}

\item{verbosity}{How verbose should the process be, as integer from \eqn{[0,6]}, default: \code{0}}

\item{seed}{Seed for internal randomization}

\item{k}{Utility constant, by default turned off. Good value is 1.3. Constant controlling speed of erasing obsolete nodes,
see \url{http://sund.de/netze/applets/gng/full/tex/DemoGNG/node20.html}}
}
\description{
Construct GNG object. Can be used to train offline, or online.
}
\examples{
\dontrun{
X <- gng.preset.sphere(100)
y <- round(runif(100))
# Train in an offline manner
gng <- GNG(X, labels=y, max.nodes=20)
# Plot
plot(gng)

# Train in an online manner with utility (erasing obsolete nodes)
gng <- GNG(max.nodes=20, train.online=TRUE, k=1.3, dim=3)
insertExamples(gng, X, labels=y)
run(gng)
Sys.sleep(10)
terminate(gng)
# Plot
plot(gng)
}
}

