% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{uchol}
\alias{uchol}
\title{Get the upper factor of the upper Cholesky decomposition of a symmetric
positive definite matrix.}
\usage{
uchol(m)
}
\arguments{
\item{m}{Matrix to factorize.}
}
\value{
A \code{p*p} upper triangular matrix.
}
\description{
Get the upper factor of the upper Cholesky decomposition of a symmetric
positive definite matrix.
}
\details{
The upper factor \code{U} such that \code{m = U \%*\% t(U)}. \code{U} is equal to the
transpose with respect to the anti-diagonal of the standard Cholesky factor
\code{L} in \code{m_rev = L \%*\% t(L)}, where \code{m_rev} is the matrix resulting from
reverting the order of rows and columns in \code{m} (see Córdoba et al., 2019,
Section 2.2 for more details). The function uses the base \code{chol} method.
}
\references{
Córdoba I., Varando G., Bielza C., Larrañaga P., Generating
random Gaussian graphical models, \emph{arXiv}:1909.01062, 2019.
}
