% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message.R
\name{gm_import_message}
\alias{gm_import_message}
\title{Import a message into the gmail mailbox from a mime message}
\usage{
gm_import_message(mail, label_ids, type = c("multipart", "media",
  "resumable"), internal_date_source = c("dateHeader", "recievedTime"),
  user_id = "me")
}
\arguments{
\item{mail}{mime mail message created by mime}

\item{label_ids}{optional label ids to apply to the message}

\item{type}{the type of upload to perform}

\item{internal_date_source}{whether to date the object based on the date of
the message or when it was received by gmail.}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Import a message into the gmail mailbox from a mime message
}
\examples{
\dontrun{
gm_import_message(gm_mime(From="you@me.com", To="any@one.com",
                          Subject="hello", "how are you doing?"))
}
}
\references{
\url{https://developers.google.com/gmail/api/v1/reference/users/messages/import}
}
\seealso{
Other message: \code{\link{gm_attachment}},
  \code{\link{gm_delete_message}},
  \code{\link{gm_insert_message}},
  \code{\link{gm_messages}}, \code{\link{gm_message}},
  \code{\link{gm_modify_message}},
  \code{\link{gm_save_attachments}},
  \code{\link{gm_save_attachment}},
  \code{\link{gm_send_message}},
  \code{\link{gm_trash_message}},
  \code{\link{gm_untrash_message}}
}
\concept{message}
