% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-helper.R
\name{valid_linkages}
\alias{valid_linkages}
\title{Check if Linkages are Valid}
\usage{
valid_linkages(linkages)
}
\arguments{
\item{linkages}{A character vector of linkages.}
}
\value{
A logical vector.
}
\description{
Valid linkages are in the form of "a1-2", "b1-4", "a?-1", etc.
Specifically, the pattern is \code{xy-z}:
\itemize{
\item \code{x}: the anomer, either "a", "b", or "?".
\item \code{y}: the first position, either "1", "2" or "?".
\item \code{z}: the second position, either a 1-9 digit or "?".
Can also be multiple positions separated by "/", e.g. "1/2/3".
"?" could not be used with "/".
}
}
\examples{
# Valid linkages
valid_linkages(c("a1-2", "?1-4", "a?-1", "b?-?", "??-?", "a1/2-3"))

# Invalid linkages
valid_linkages(c("a1-2/?", "1-4", "a/b1-2", "c1-2", "a9-1"))

}
