% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-lines.R
\name{md_softline}
\alias{md_softline}
\title{Markdown soft line breaks}
\usage{
md_softline(...)
}
\arguments{
\item{...}{Any number of character vectors.}
}
\value{
A \code{glue} vector with elements of \code{...} separated by a single newline.
}
\description{
Take a character vector and return a glue vector of separated by a single
newline. This inline is rendered as single \verb{<p>} HTML tags.
}
\details{
A regular line break (not in a code span or HTML tag) that is not preceded by
two or more spaces or a backslash is parsed as a softbreak. (A softbreak may
be rendered in HTML either as a line ending or as a space. The result will be
the same in browsers. In the examples here, a line ending will be used.)
}
\examples{
# compare the following
md_bold(c("One", "Two"))

md_softline(md_bold(c("One", "Two")))
}
\seealso{
Other inline functions: 
\code{\link{md_autolink}()},
\code{\link{md_bold}()},
\code{\link{md_code}()},
\code{\link{md_convert}()},
\code{\link{md_disallow}()},
\code{\link{md_escape}()},
\code{\link{md_hardline}()},
\code{\link{md_image}()},
\code{\link{md_issue}()},
\code{\link{md_italic}()},
\code{\link{md_link}()},
\code{\link{md_strike}()},
\code{\link{md_text}()}
}
\concept{inline functions}
