% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{data_score}
\alias{data_score}
\alias{example_score}
\title{data_score}
\format{
A tibble with 6,000 rows and 8 variables:
\describe{
\item{location}{Column of type \code{character} showing the ISO2 code of
the country or region for which the data was computed.}
\item{keyword}{Column of type \code{character} showing the keyword for
which the data was downloaded.}
\item{date}{Column of type \code{integer} showing the date for which the
data was computed Can be transformed into date format with
\code{lubridate::as_date}.}
\item{score_obs}{Column of type \code{double} showing search score for the
respective location-keyword-date combination - no time series adjustment.}
\item{score_sad}{Column of type \code{double} showing the search score for
the respective location-keyword-date combination - seasonally adjusted time
series.}
\item{score_trd}{Column of type \code{double} showing the search score for
the respective location-keyword-date combination - trend-only time series.}
\item{batch_c}{Column of type \code{integer} showing the number of each
control batch.}
\item{batch_o}{Column of type \code{integer} showing the number of each
object batch.}
\item{synonym}{Column of type \code{integer} showing whether the line will
be aggregated as synonym.}
}
}
\usage{
example_score
}
\description{
The table \emph{data_score} contains the search scores for each object batch.
Each line contains the observed search score (\emph{score_obs}), the
seasonally adjusted search score (\emph{score_sad}), and the trend only
search score (\emph{score_trd}) for each \emph{keyword} in an object
\emph{batch_o} for a given \emph{location} and \emph{date}. The column
\emph{batch_c} indicates the control batch that has been used as baseline
for mapping. Global data takes the value \emph{world} as location. Search
scores are computed and automatically written to the table with the function
\code{compute_score}. The function \code{start_db} exports the table
\emph{data_score} as database connection \code{tbl_score} to
the package environment \code{gt.env}. Users can access the database
table through \code{dplyr::tbl}.
The sample data included in \code{data_score} was simulated based on actual
Google Trends data.

Example data for the table \emph{data_score} is available as R object
\code{example_score}.
}
\seealso{
\itemize{
\item \code{\link[=compute_score]{compute_score()}}
\item \code{\link[=compute_voi]{compute_voi()}}
\item \code{\link[dplyr:tbl]{dplyr::tbl()}}
}
}
\keyword{datasets}
