% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.r
\docType{data}
\name{gt.env}
\alias{gt.env}
\title{globaltrends package environment}
\format{
An object of class \code{environment} of length 14.
}
\usage{
gt.env
}
\description{
The environment \code{gt.env} contains all package-related data objects, such as
the handle for the SQLite database file or connections to tables. The object
involve:
\itemize{
\item globaltrends_db: Handle for the SQLite database file.
\item tbl_locations: Connection to table that contains the lists of locations saved in the database.
\item tbl_keywords: Connection to table that contains the lists of keywords saved in the database.
\item tbl_time: Connection to table that contains the lists of batch times saved in the database.
\item tbl_synonyms: Connection to table that contains the lists of keyword synonyms saved in the database.
\item tbl_doi: Connection to table that contains the DOI data saved in the database.
\item tbl_control: Connection to table that contains data on search volume for control terms saved in the database.
\item tbl_object: Connection to table that contains data on search volume for object terms saved in the database.
\item tbl_score: Connection to table that contains data on search scores saved in the database.
\item keywords_control: Tibble that contains all keywords per control batch.
\item time_control: Tibble that contains all batch times per control batch.
\item keywords_object: Tibble that contains all keywords per object batch.
\item time_object: Tibble that contains all batch times per object batch.
\item keyword_synonyms: Tibble that contains all keyword/synonym combinations.
}
}
\seealso{
\itemize{
\item \code{\link[=example_control]{example_control()}}
\item \code{\link[=example_object]{example_object()}}
\item \code{\link[=example_score]{example_score()}}
\item \code{\link[=example_doi]{example_doi()}}
}
}
\keyword{datasets}
