% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{swimmers}
\alias{swimmers}
\title{Self diagnozed ear infections in swimmers}
\format{
A data frame with 287 rows and 5 variables:
\describe{
  \item{frequency}{a factor giving the recruit's perception of whether he or she is a frequent swimmer: "frequent" and "occasional".}
  \item{location}{a factor giving the recruit's usually chosen swimming location: "beach" and "non-beach".}
  \item{age}{a factor giving the recruit's age range: "15-19", "20-24" and "25-29".}
  \item{gender}{a factor giving the recruit's gender: "male" and "female".}
  \item{infections}{a numeric vector giving the number of self diagnozed
        ear infections that were reported by the recruit.}
}
}
\usage{
data(swimmers)
}
\description{
A pilot surf/health study was conducted by NSW Water
Board in 1990 on 287 recruits. The objective of the study was to
determine whether beach swimmers run an increased risk of contracting
ear infections than non-beach swimmers.
}
\examples{
data(swimmers)
dev.new()
boxplot(infections ~ frequency, data=subset(swimmers,location=="non-beach"),
        at=c(1:2) - 0.2, col="yellow", boxwex=0.25, xaxt="n")
boxplot(infections ~ frequency, data=subset(swimmers,location=="beach"), add=TRUE,
        at=c(1:2) + 0.2, col="blue", boxwex=0.25, xaxt="n")
axis(1, at=c(1:2), labels=levels(swimmers$frequency))
legend("topleft", title="Location",legend=c("non-beach","beach"),
       fill=c("yellow","blue"),bty="n")
}
\references{
Hand D.J., Daly F., Lunn A.D., McConway K.J., Ostrowsky E. (1994)
\emph{A Handbook of Small Data Sets}, Chapman and Hall, London.

Vanegas L.H., Rondon L.M. (2020) A data transformation to deal with
constant under/over-dispersion in binomial and poisson regression models. \emph{Journal
of Statistical Computation and Simulation} 90:1811-1833.
}
\keyword{datasets}
