% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{envelope.overglm}
\alias{envelope.overglm}
\title{Normal QQ-plot with Simulated Envelope of Residuals for alternatives to the Poisson and Binomial Regression Models under the presence of Overdispersion}
\usage{
\method{envelope}{overglm}(
  object,
  rep = 25,
  conf = 0.95,
  type = c("quantile", "response", "standardized"),
  plot.it = TRUE,
  identify,
  ...
)
}
\arguments{
\item{object}{an object of class \emph{overglm}.}

\item{rep}{an (optional) positive integer which allows to specify the number of replicates which should be used to build the simulated envelope. By default, \code{rep} is set to be 25.}

\item{conf}{an (optional) value in the interval \eqn{(0,1)} indicating the confidence level which should be used to build the pointwise confidence intervals, which conform the simulated envelope. By default, \code{conf} is set to be 0.95.}

\item{type}{an (optional) character string which allows to specify the required type of residuals. The available options are: (1) the difference between the observed response
and the fitted mean ("response"); (2) the standardized difference between the observed response and the fitted mean ("standardized"); and (3) the randomized quantile
residual ("quantile"). By default, \code{type} is set to be "quantile".}

\item{plot.it}{an (optional) logical switch indicating if the normal QQ-plot with simulated envelope of residuals is required or just the data matrix in which it is based. By default, \code{plot.it} is set to be TRUE.}

\item{identify}{an (optional) positive integer value indicating the number of individuals to identify on the QQ-plot with simulated envelope of residuals. This is only appropriate if \code{plot.it=TRUE}.}

\item{...}{further arguments passed to or from other methods. If \code{plot.it=TRUE} then \code{...} may be used to include graphical parameters to customize the plot. For example, \code{col}, \code{pch}, \code{cex}, \code{main}, \code{sub}, \code{xlab}, \code{ylab}.}
}
\value{
A matrix with the following four columns:
\tabular{ll}{
\code{Lower limit} \tab the quantile (1 - \code{conf})/2 of the random sample of size \code{rep} of the \eqn{i}-th order\cr
                   \tab  statistic of the \code{type}-type residuals for \eqn{i=1,2,...,n},\cr
\tab \cr
\code{Median} \tab the quantile 0.5 of the random sample of size \code{rep} of the \eqn{i}-th order\cr
              \tab  statistic of the \code{type}-type residuals for \eqn{i=1,2,...,n},\cr
\tab \cr
\code{Upper limit} \tab the quantile (1 + \code{conf})/2 of the random sample of size \code{rep} of the \eqn{i}-th order\cr
                   \tab  statistic of the \code{type}-type residuals for \eqn{i=1,2,...,n},\cr
\tab \cr
\code{Residuals}\tab the observed \code{type}-type residuals,\cr
}
}
\description{
Produces a normal QQ-plot with simulated envelope of residuals for regression models based on the negative binomial, beta-binomial, and random-clumped binomial
distributions, which are alternatives to the Poisson and binomial regression models under the presence of overdispersion.
}
\details{
The simulated envelope is builded by simulating \code{rep} independent realizations of the response variable for each
individual, which is accomplished taking into account the following: (1) the model assumption about the distribution of
the response variable; (2) the estimates of the parameters in the linear predictor; and (3) the estimate of the
dispersion parameter. The interest model is re-fitted \code{rep} times, as each time the vector of observed responses
is replaced by one of the simulated samples. The \code{type}-type residuals are computed and then sorted for each
replicate, so that for each \eqn{i=1,2,...,n}, where \eqn{n} is the number of individuals in the sample, there is a random
sample of size \code{rep} of the \eqn{i}-th order statistic of the  \code{type}-type residuals. Therefore, the simulated
envelope is composed of the quantiles (1 - \code{conf})/2 and (1 + \code{conf})/2 of the random sample of size \code{rep} of
the \eqn{i}-th order statistic of the \code{type}-type residuals for \eqn{i=1,2,...,n}.
}
\examples{
###### Example 1: Self diagnozed ear infections in swimmers
data(swimmers)
fit1 <- overglm(infections ~ frequency + location, family="nb1(log)", data=swimmers)
envelope(fit1, rep=30, conf=0.95, type="quantile", col="red", pch=20, col.lab="blue",
         col.axis="blue", col.main="black", family="mono", cex=0.8, plot.it=TRUE)

###### Example 2: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit2 <- overglm(art ~ fem + kid5 + ment, family="nb1(log)", data = bioChemists)
envelope(fit2, rep=30, conf=0.95, type="quantile", col="red", pch=20, col.lab="blue",
         col.axis="blue", col.main="black", family="mono", cex=0.8, plot.it=TRUE)

###### Example 3: Agents to stimulate cellular differentiation
data(cellular)
fit3 <- overglm(cbind(cells,200-cells) ~ tnf + ifn, family="bb(logit)", data=cellular)
envelope(fit3, rep=30, conf=0.95, type="quantile", col="red", pch=20, col.lab="blue",
         col.axis="blue", col.main="black", family="mono", cex=0.8, plot.it=TRUE)

}
\references{
Atkinson A.C. (1985) \emph{Plots, Transformations and Regression}. Oxford University Press, Oxford.

Dunn P.K., Smyth G.K. (1996) Randomized Quantile Residuals. \emph{Journal of Computational and Graphical Statistics} 5, 236-244.
}
\seealso{
\link{envelope.lm}, \link{envelope.glm}, \link{envelope.zeroinflation}
}
