% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{anova.glmgee}
\alias{anova.glmgee}
\title{Comparison of nested Generalized Estimating Equations}
\usage{
\method{anova}{glmgee}(
  object,
  ...,
  test = c("wald", "score"),
  verbose = TRUE,
  varest = c("robust", "df-adjusted", "model", "bias-corrected")
)
}
\arguments{
\item{object}{an (object) of the class glmgee which is obtained from the fit of a generalized estimating equation.}

\item{...}{another objects of the class glmgee which are obtained from the fit of generalized estimating equations.}

\item{test}{an (optional) character string indicating the required test. The available options are: Wald ("wald") and generalized score ("score") tests. By default, \code{test} is set to be "wald".}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{varest}{an (optional) character string indicating the type of estimator which should be used to the variance-covariance matrix of the interest parameters in the Wald test. The available options are: robust sandwich-type estimator ("robust"), degrees-of-freedom-adjusted estimator ("df-adjusted"), bias-corrected estimator ("bias-corrected"), and the model-based or naive estimator ("model"). By default, \code{varest} is set to be "robust". See \link{vcov.glmgee}.}
}
\value{
A matrix with three columns which contains the following:
\itemize{
\item \code{Chi:}{ The value of the statistic of the test.}
\item \code{df:}{ The number of degrees of freedom.}
\item \code{Pr(>Chi):}{ The \emph{p}-value of the test computed using the Chi-square distribution.}
}
}
\description{
Allows to compare nested generalized estimating equations using the Wald and generalized score tests.
}
\examples{
## Example 1
mod <- size ~ poly(days,4)
fit1 <- glmgee(mod, id=tree, family=Gamma("log"), data=spruces, corstr="AR-1")
fit2 <- update(fit1, . ~ . + treat)
fit3 <- update(fit2, . ~ . + poly(days,4):treat)
anova(fit1,fit2,fit3,test="wald")
anova(fit3,test="wald")
anova(fit1,fit2,fit3,test="score")
anova(fit3,test="score")

## Example 2
mod2 <- depressd ~ group
fit1 <- glmgee(mod2, id=subj, family=binomial("logit"), corstr="Exchangeable", data=depression)
fit2 <- update(fit1, . ~ . + visit)
fit3 <- update(fit2, . ~ . + group:visit)
anova(fit1,fit2,fit3,test="wald")
anova(fit3,test="wald")
anova(fit1,fit2,fit3,test="score")
anova(fit3,test="score")

## Example 3
mod3 <- dep ~ group
fit1 <- glmgee(mod3, id=subj, family=gaussian("identity"), corstr="AR-1", data=depression)
fit2 <- update(fit1, . ~ . + visit)
fit3 <- update(fit2, . ~ . + group:visit)
anova(fit1,fit2,fit3,test="wald")
anova(fit3,test="wald")
anova(fit1,fit2,fit3,test="score")
anova(fit3,test="score")
}
\references{
Boos D. (1992) On Generalized Score Tests. \emph{American Statistician} 46, 327–33.

Rotnitzky A. and Jewell N.P. (1990). Hypothesis Testing of Regression Parameters in Semiparametric Generalized Linear Models for Cluster Correlated Data. \emph{Biometrika} 77, 485-497.
}
