% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.stepreg_230218.R
\name{cv.stepreg}
\alias{cv.stepreg}
\title{Cross validation informed stepwise regression model fit.}
\usage{
cv.stepreg(
  xs_cv,
  start_cv = NULL,
  y_cv,
  event_cv,
  steps_n = 0,
  folds_n = 10,
  method = "loglik",
  family = "cox",
  foldid = NULL,
  track = 0
)
}
\arguments{
\item{xs_cv}{predictor input - an n by p matrix, where n (rows) is sample size, and p (columns) 
the number of predictors.  Must be in matrix form for complete data, no NA's, no Inf's, etc.,
and not a data frame.}

\item{start_cv}{start time, Cox model only - class numeric of length same as number of patients (n)}

\item{y_cv}{output vector: time, or stop time for Cox model, Y_ 0 or 1 for binomal (logistic), numeric for gaussian. 
#' Must be a vector of length same as number of sample size.}

\item{event_cv}{event indicator, 1 for event, 0 for census, Cox model only.
Must be a numeric vector of length same as sample size.}

\item{steps_n}{Maximun number of steps done in stepwise regression fitting.  If 0, then takes the value rank(xs_cv).}

\item{folds_n}{number of folds for cross validation}

\item{method}{method for choosing model in stepwise procedure, "loglik" or "concordance".
Other procedures use the "loglik".}

\item{family}{model family, "cox", "binomial" or "gaussian"}

\item{foldid}{a vector of integers to associate each record to a fold.  The integers should be between 1 and folds_n.}

\item{track}{indicate whether or not to update progress in the console.  Default of
0 suppresses these updates.  The option of 1 provides these updates.  
In fitting clinical data with non full rank design matrix we have found some 
R-packages to take a very long time.  Therefore we allow the user to track the 
program progress and judge whether things are 
moving forward or if the process should be stopped.}
}
\value{
cross validation infomred stepwise regression model fit tuned by number of model terms or p-value for inclusion.
}
\description{
Cross validation informed stepwise regression model fit.
}
\examples{
set.seed(955702213)
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=c(0,1,1))
# this gives a more interesting case but takes longer to run
xs=sim.data$xs           
# this will work numerically as an example 
xs=sim.data$xs[,c(2,3,50:55)] 
dim(xs)
y_=sim.data$yt 
event=sim.data$event
# for this example we use small numbers for steps_n and folds_n to shorten run time 
cv.stepreg.fit = cv.stepreg(xs, NULL, y_, event, steps_n=10, folds_n=3, track=0)
summary(cv.stepreg.fit)

}
