% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.nested.glmnetr_230508.R
\name{glmnetr.compcv}
\alias{glmnetr.compcv}
\title{Compare cross validation fits from a nested.glmnetr output.}
\usage{
glmnetr.compcv(object)
}
\arguments{
\item{object}{A nested.glmnetr output object.}
}
\value{
A printout to the R console.
}
\description{
Compare cross-validation model fits in terms of average concordance from the 
nested cross validaiton fits.
}
\examples{
\donttest{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
fit3 = nested.glmnetr(xs, NULL, y_, event, family="cox", folds_n=3) 
glmnetr.compcv(fit3)
}

}
\seealso{
\code{\link{summary.nested.glmnetr}}
}
