% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxgrad.R
\name{coxgrad}
\alias{coxgrad}
\title{compute gradient for cox model}
\usage{
coxgrad(f, time, d, w, eps = 1e-05)
}
\arguments{
\item{f}{fit vector}

\item{time}{time vector (can have ties)}

\item{d}{death/censoring indicator 1/0}

\item{w}{observation weights (default equal)}

\item{eps}{(default 0.00001) Breaks ties between death and censoring by making death times \code{eps} earlier}
}
\value{
a single gradient vector the same length as \code{f}
}
\description{
Compute the gradient of the partial likelihood at a particular fit
}
\details{
Compute a gradient vector at the fitted vector for the log partial likelihood.
This is like a residual vector, and useful for manual screening of predictors for \code{glmnet}
in applications where \code{p} is very large (as in GWAS). Uses the Breslow approach to ties
}
\seealso{
\code{coxnet.deviance}
}
\author{
Trevor Hastie\cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{Cox}
\keyword{model}
