# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Markov Chain Monte Carlo Maximum Likelihood Algorithm 
#' 
#' Full Markov Chain Monte Carlo Maximum Likelihood Algorithm using c++ code and the inbuilt Hamiltonian Monte Carlo MCMC sampler.
#' Given their complex interface, these functions are not intended to be used by the normal user who can access this functionality 
#' with the member functions of the \link[glmmrMCML]{ModelMCML} class.
#' 
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param start Vector of starting values for the optimisation
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=ever more detailed output
#' @param mcnr Logical indicating whether to use Newton-Raphson (TRUE) or Expectation Maximisation (FALSE)
#' @param m Integer. Total number of MCMC samples to draw on each iteration
#' @param maxiter Integer. The maximum number of MCML iterations
#' @param warmup Integer. The number of warmup iterations for the MCMC sampler. Note, this reduces to 10 after
#' the first iteration as the sampler starts from the last set of values and adaptive step size
#' @param tol Value of the tolerance. The algorithm termninates if differences in values of parameters between
#' iterations are all less than this value.
#' @param verbose Logical indicating whether to provide output to the console
#' @param lambda Value of the trajectory length of the leapfrog integrator in Hamiltonian Monte Carlo
#'  (equal to number of steps times the step length). Larger values result in lower correlation in samples, but
#'  require larger numbers of steps and so is slower.
#' @param refresh Integer. Number of MCMC iterations to print progress to the console (requires verbose=TRUE)
#' @param maxsteps Integer. The maximum number of steps of the leapfrom integrator
#' @param target_accept The target acceptance rate of HMC proposals (default 0.9)
#' @return A list with the maximum likelihood estimates of the model parameters, the final set of MCMC samples, and
#' and indciator for whether the algorithm converged.
#' @examples
#' \dontrun{
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(10) * t(3)) > i(5))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## fit model using default arguments for HMC sampler
#' out <- mcml_full(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,3),0.25,0.7,1.0),
#'    mcnr = TRUE)
#' }
mcml_full <- function(cov, data, eff_range, Z, X, y, family, link, start, mcnr = FALSE, m = 500L, maxiter = 30L, warmup = 500L, tol = 1e-3, verbose = TRUE, lambda = 0.05, trace = 0L, refresh = 500L, maxsteps = 100L, target_accept = 0.9) {
    .Call(`_glmmrMCML_mcml_full`, cov, data, eff_range, Z, X, y, family, link, start, mcnr, m, maxiter, warmup, tol, verbose, lambda, trace, refresh, maxsteps, target_accept)
}

#' Hamiltonian Monte Carlo Sampler for Model Random Effects
#' 
#' Hamiltonian Monte Carlo Sampler for Model Random Effects. 
#' 
#' @param Z Matrix Z of the GLMM
#' @param L Matrix L, the Cholesky decomposition of the random effect covariance (returned with `gen_chol_D()` function of covariance)
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param beta Vector of parameters multiplying the X matrix
#' @param var_par (Optional) Value of the scale parameter where required (Gaussian and gamma distributions) 
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=ever more detailed output
#' @param nsamp Integer. Total number of MCMC samples to draw on each iteration
#' @param warmup Integer. The number of warmup iterations for the MCMC sampler. Note, this reduces to 10 after
#' the first iteration as the sampler starts from the last set of values and adaptive step size
#' @param lambda Value of the trajectory length of the leapfrog integrator in Hamiltonian Monte Carlo
#'  (equal to number of steps times the step length). Larger values result in lower correlation in samples, but
#'  require larger numbers of steps and so is slower.
#' @param refresh Integer. Number of MCMC iterations to print progress to the console (requires verbose=TRUE)
#' @param maxsteps Integer. The maximum number of steps of the leapfrom integrator
#' @param target_accept The target acceptance rate of HMC proposals (default 0.9)
#' @return A matrix (of dimension number of random effects * number of samples)
#' @examples
#' ## small example with simulated data
#' df <- nelder(~(j(10) * t(3)) > i(5))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## simulate some values of the random effects
#' ## first, we need to extract the Cholesky decomposition of the covariance matrix D
#' L <- des$covariance$get_chol_D()
#' ## generate samples using HMC
#' mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
#'    L = as.matrix(L),
#'    X = as.matrix(des$mean_function$X),
#'    y = as.vector(y),
#'    beta = des$mean_function$parameters,
#'    var_par = 1,
#'    family = des$mean_function$family[[1]],
#'    link = des$mean_function$family[[2]],
#'    warmup = 250, 
#'    nsamp = 250,
#'    lambda = 5,
#'    maxsteps = 100,
#'    trace=1,
#'    target_accept = 0.95)
mcmc_sample <- function(Z, L, X, y, beta, family, link, warmup, nsamp, lambda, var_par = 1, trace = 0L, refresh = 500L, maxsteps = 100L, target_accept = 0.9) {
    .Call(`_glmmrMCML_mcmc_sample`, Z, L, X, y, beta, family, link, warmup, nsamp, lambda, var_par, trace, refresh, maxsteps, target_accept)
}

#' Maximum Likelihood with Laplace Approximation and Derivative Free Optimisation
#' 
#' Maximum Likelihood with Laplace Approximation and Derivative Free Optimisation. These
#' functions are not intended to be used by the normal user who can access this functionality 
#' with the member functions of the \link[glmmrMCML]{ModelMCML} class. 
#' 
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param start Vector of starting values for the optimisation
#' @param usehess Logical inticating whether to estimate the standard errors from the Hessian matrix
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=ever more detailed output
#' @param tol Value of the tolerance. The algorithm termninates if differences in values of parameters between
#' iterations are all less than this value.
#' @param verbose Logical indicating whether to provide output to the console
#' @param maxiter Integer. Maximum number of algorithm iterations before exiting.
#' @return A list with estimates of model parameters, standard errors, and random effects
#' @examples
#' \donttest{
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(10) * t(3)) > i(5))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' out3 <- mcml_la(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,5),0.25,0.7,1.0),
#'    usehess = FALSE,
#'    tol=1e-2,verbose=FALSE,trace=0)
#'    }
mcml_la <- function(cov, data, eff_range, Z, X, y, family, link, start, usehess = FALSE, tol = 1e-3, verbose = TRUE, trace = 0L, maxiter = 10L) {
    .Call(`_glmmrMCML_mcml_la`, cov, data, eff_range, Z, X, y, family, link, start, usehess, tol, verbose, trace, maxiter)
}

#' Maximum Likelihood with Laplace Approximation and Newton-Raphson 
#' 
#' Maximum Likelihood with Laplace Approximation and Newton-Raphson. These
#' functions are not intended to be used by the normal user who can access this functionality 
#' with the member functions of the \link[glmmrMCML]{ModelMCML} class. 
#' 
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param start Vector of starting values for the optimisation
#' @param usehess Logical inticating whether to estimate the standard errors from the Hessian matrix
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=ever more detailed output
#' @param tol Value of the tolerance. The algorithm termninates if differences in values of parameters between
#' iterations are all less than this value.
#' @param verbose Logical indicating whether to provide output to the console
#' @param maxiter Integer. Maximum number of algorithm iterations before exiting.
#' @return A list with estimates of model parameters, standard errors, and random effects
#' @examples
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(10) * t(3)) > i(5))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' out3 <- mcml_la_nr(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,5),0.25,0.7,1.0),
#'    usehess = FALSE,
#'    tol=1e-2,verbose=FALSE,trace=0)
mcml_la_nr <- function(cov, data, eff_range, Z, X, y, family, link, start, usehess = FALSE, tol = 1e-3, verbose = TRUE, trace = 0L, maxiter = 10L) {
    .Call(`_glmmrMCML_mcml_la_nr`, cov, data, eff_range, Z, X, y, family, link, start, usehess, tol, verbose, trace, maxiter)
}

#' Likelihood maximisation for the GLMM 
#' 
#' Given model data and random effects samples `u`, this function will run the MCML steps to generate new estimates of 
#' mean function and covariance parameters. These functions are not intended to be used by the general user since 
#' the complete model fitting algorithm can be accessed through the member functions of the \link[glmmrMCML]{ModelMCML} 
#' class. These functions are exported for users wishing to use the modular components or each step 
#' separately of the MCML algorithm.
#' 
#' @details
#' Member function `$get_D_data()` of the covariance class will provide the necessary objects to specify the covariance matrix
#' 
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param u Matrix of samples of the random effects. Each column is a sample.
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param start Vector of starting values for the optimisation
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=detailed output
#' @param mcnr Logical indicating whether to use Newton-Raphson (TRUE) or Expectation Maximisation (FALSE)
#' @return A vector of the parameters that maximise the likelihood functions
#' @examples
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(8) * t(3)) > i(4))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## simulate some values of the random effects
#' ## first, we need to extract the Cholesky decomposition of the covariance matrix D
#' L <- des$covariance$get_chol_D()
#' ## generate samples using HMC
#' mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
#'    L = as.matrix(L),
#'    X = as.matrix(des$mean_function$X),
#'    y = as.vector(y),
#'    beta = des$mean_function$parameters,
#'    var_par = 1,
#'    family = des$mean_function$family[[1]],
#'    link = des$mean_function$family[[2]],
#'    warmup = 250, 
#'    nsamp = 250,
#'    lambda = 5,
#'    maxsteps = 100,
#'    trace=1,
#'    target_accept = 0.95)
#' out <- mcml_optim(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    u = mat,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,3),0.25,0.7,1.0),
#'    trace=0,
#'    mcnr = TRUE)
mcml_optim <- function(cov, data, eff_range, Z, X, y, u, family, link, start, trace, mcnr = FALSE) {
    .Call(`_glmmrMCML_mcml_optim`, cov, data, eff_range, Z, X, y, u, family, link, start, trace, mcnr)
}

#' Simulated likelihood optimisation step for MCML
#' 
#' Conditional on values of the random effects terms, this function will return the maximum simulated likelihood 
#' parameter estimates. These functions are not intended to be used by the general user since 
#' the complete model fitting algorithm can be accessed through the member functions of the \link[glmmrMCML]{ModelMCML} 
#' class. These functions are exported for users wishing to use the modular components or each step 
#' separately of the MCML algorithm.
#' 
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param u Matrix of samples of the random effects. Each column is a sample.
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param start Vector of starting values for the optimisation
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=detailed output
#' @return A vector of the parameters that maximise the simulated likelihood
#' @examples
#' \donttest{
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(8) * t(3)) > i(4))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## simulate some values of the random effects
#' ## first, we need to extract the Cholesky decomposition of the covariance matrix D
#' L <- des$covariance$get_chol_D()
#' ## generate samples using HMC
#' mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
#'    L = as.matrix(L),
#'    X = as.matrix(des$mean_function$X),
#'    y = as.vector(y),
#'    beta = des$mean_function$parameters,
#'    var_par = 1,
#'    family = des$mean_function$family[[1]],
#'    link = des$mean_function$family[[2]],
#'    warmup = 250, 
#'    nsamp = 250,
#'    lambda = 5,
#'    maxsteps = 100,
#'    trace=1,
#'    target_accept = 0.95)
#' out <- mcml_simlik(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    u = mat,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,3),0.25,0.7,1.0),
#'    trace=0)
#' }
mcml_simlik <- function(cov, data, eff_range, Z, X, y, u, family, link, start, trace) {
    .Call(`_glmmrMCML_mcml_simlik`, cov, data, eff_range, Z, X, y, u, family, link, start, trace)
}

#' Likelihood maximisation for the GLMM using sparse matrix methods
#' 
#' Given model data and random effects samples `u`, this function will run the MCML steps to generate new estimates of 
#' mean function and covariance parameters. This version of the function uses sparse matrix methods for the operations involving
#' the random effects covariance matrix, see \link[Matrix]{dsCMatrix-class} for specification. 
#' These functions are not intended to be used by the general user since 
#' the complete model fitting algorithm can be accessed through the member functions of the \link[glmmrMCML]{ModelMCML} 
#' class. These functions are exported for users wishing to use the modular components or each step 
#' separately of the MCML algorithm.
#' 
#' Likelihood maximisation for the GLMM
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Ap Integer vector of pointers, one for each column, specifying the initial (zero-based) index of elements in the column. Slot `p`
#' of a matrix of a class defined in \link[Matrix]{sparseMatrix}
#' @param Ai Integer vector specifying the row indices of the non-zero elements of the matrix. Slot `i`
#' of a matrix of a class defined in \link[Matrix]{sparseMatrix}
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param u Matrix of samples of the random effects. Each column is a sample.
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param start Vector of starting values for the optimisation
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=detailed output
#' @param mcnr Logical indicating whether to use Newton-Raphson (TRUE) or Expectation Maximisation (FALSE)
#' @return A vector of the parameters that maximise the simulated likelihood
#' @examples
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(8) * t(3)) > i(4))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## simulate some values of the random effects
#' ## first, we need to extract the Cholesky decomposition of the covariance matrix D
#' L <- des$covariance$get_chol_D()
#' ## generate samples using HMC - note this step does not use the sparse matrix
#' mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
#'    L = as.matrix(L),
#'    X = as.matrix(des$mean_function$X),
#'    y = as.vector(y),
#'    beta = des$mean_function$parameters,
#'    var_par = 1,
#'    family = des$mean_function$family[[1]],
#'    link = des$mean_function$family[[2]],
#'    warmup = 250, 
#'    nsamp = 250,
#'    lambda = 5,
#'    maxsteps = 100,
#'    trace=1,
#'    target_accept = 0.95)
#' ## the specification of the covariance above results in a sparse covariance matrix,
#' ## so we can just extract the components as below.
#' out <- mcml_optim_sparse(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Ap = des$covariance$D@p,
#'    Ai = des$covariance$D@i,
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    u = mat,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,3),0.25,0.7,1.0),
#'    trace=0,
#'    mcnr = TRUE)
mcml_optim_sparse <- function(cov, data, eff_range, Ap, Ai, Z, X, y, u, family, link, start, trace, mcnr = FALSE) {
    .Call(`_glmmrMCML_mcml_optim_sparse`, cov, data, eff_range, Ap, Ai, Z, X, y, u, family, link, start, trace, mcnr)
}

#' Simulated likelihood optimisation step for MCML using sparse matrix methods
#' 
#' Given model data and random effects samples `u`, this function will run the MCML steps to generate new estimates of 
#' mean function and covariance parameters that maximise the simulated likelihood. This version of the function uses sparse matrix methods for the operations involving 
#' the random effects covariance matrix, see \link[Matrix]{dsCMatrix-class} for specification. 
#' These functions are not intended to be used by the general user since 
#' the complete model fitting algorithm can be accessed through the member functions of the \link[glmmrMCML]{ModelMCML} 
#' class. These functions are exported for users wishing to use the modular components or each step 
#' separately of the MCML algorithm.
#' 
#' Likelihood maximisation for the GLMM
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Ap Integer vector of pointers, one for each column, specifying the initial (zero-based) index of elements in the column. Slot `p`
#' of a matrix of a class defined in \link[Matrix]{sparseMatrix}
#' @param Ai Integer vector specifying the row indices of the non-zero elements of the matrix. Slot `i`
#' of a matrix of a class defined in \link[Matrix]{sparseMatrix}
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param u Matrix of samples of the random effects. Each column is a sample.
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param start Vector of starting values for the optimisation
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=detailed output
#' @return A vector of the parameters that maximise the simulated likelihood
#' @examples
#' \donttest{
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(10) * t(3)) > i(5))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## simulate some values of the random effects
#' ## first, we need to extract the Cholesky decomposition of the covariance matrix D
#' L <- des$covariance$get_chol_D()
#' ## generate samples using HMC - note this step does not use the sparse matrix
#' mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
#'    L = as.matrix(L),
#'    X = as.matrix(des$mean_function$X),
#'    y = as.vector(y),
#'    beta = des$mean_function$parameters,
#'    var_par = 1,
#'    family = des$mean_function$family[[1]],
#'    link = des$mean_function$family[[2]],
#'    warmup = 250, 
#'    nsamp = 250,
#'    lambda = 5,
#'    maxsteps = 100,
#'    trace=1,
#'    target_accept = 0.95)
#' ## the specification of the covariance above results in a sparse covariance matrix,
#' ## so we can just extract the components as below.
#' out <- mcml_simlik_sparse(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Ap = des$covariance$D@p,
#'    Ai = des$covariance$D@i,
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    u = mat,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,3),0.25,0.7,1.0),
#'    trace=0)
#' }
mcml_simlik_sparse <- function(cov, data, eff_range, Ap, Ai, Z, X, y, u, family, link, start, trace) {
    .Call(`_glmmrMCML_mcml_simlik_sparse`, cov, data, eff_range, Ap, Ai, Z, X, y, u, family, link, start, trace)
}

#' Generate Hessian matrix of GLMM
#' 
#' Generate Hessian matrix of a GLMM using numerical differentiation. These functions are not intended to be used by the general user since 
#' the complete model fitting algorithm can be accessed through the member functions of the \link[glmmrMCML]{ModelMCML}  class. 
#' These functions are exported for users wishing to use the modular components or each step 
#' separately of the MCML algorithm.
#' 
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param u Matrix of samples of the random effects. Each column is a sample.
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param start Vector of starting values for the optimisation
#' @param tol The tolerance of the numerical differentiation routine
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=detailed output
#' @return The estimated Hessian matrix
#' @examples
#' \donttest{
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(10) * t(3)) > i(5))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## simulate some values of the random effects
#' ## first, we need to extract the Cholesky decomposition of the covariance matrix D
#' L <- des$covariance$get_chol_D()
#' ## generate samples using HMC
#' mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
#'    L = as.matrix(L),
#'    X = as.matrix(des$mean_function$X),
#'    y = as.vector(y),
#'    beta = des$mean_function$parameters,
#'    var_par = 1,
#'    family = des$mean_function$family[[1]],
#'    link = des$mean_function$family[[2]],
#'    warmup = 250, 
#'    nsamp = 250,
#'    lambda = 5,
#'    maxsteps = 100,
#'    trace=1,
#'    target_accept = 0.95)
#' ## fit model to get parameter estimates
#' out <- mcml_optim(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    u = mat,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,3),0.25,0.7,1.0),
#'    trace=0,
#'    mcnr = TRUE)
#' ## get hessian matrix
#' hess <- mcml_hess(cov=ddata$cov,
#'   data=ddata$data,
#'   eff_range = rep(0,30),
#'   Z = as.matrix(des$covariance$Z),
#'   X = as.matrix(des$mean_function$X),
#'   y = y,
#'   u = mat,
#'   family = des$mean_function$family[[1]],
#'   link=des$mean_function$family[[2]],
#'   start = c(out$beta,out$theta,out$sigma))
#' }
mcml_hess <- function(cov, data, eff_range, Z, X, y, u, family, link, start, tol = 1e-5, trace = 0L) {
    .Call(`_glmmrMCML_mcml_hess`, cov, data, eff_range, Z, X, y, u, family, link, start, tol, trace)
}

#' Generate Hessian matrix of GLMM using sparse matrix methods
#' 
#' Generate Hessian matrix of a GLMM using numerical differentiation. Operations with the random effects covariance matrix
#' use sparse matrix methods,see \link[Matrix]{dsCMatrix-class} for specification. 
#' These functions are not intended to be used by the general user since 
#' the complete model fitting algorithm can be accessed through the member functions of the \link[glmmrMCML]{ModelMCML}  class. 
#' These functions are exported for users wishing to use the modular components or each step 
#' separately of the MCML algorithm.
#'  
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Ap Integer vector of pointers, one for each column, specifying the initial (zero-based) index of elements in the column. Slot `p`
#' of a matrix of a class defined in \link[Matrix]{sparseMatrix}
#' @param Ai Integer vector specifying the row indices of the non-zero elements of the matrix. Slot `i`
#' of a matrix of a class defined in \link[Matrix]{sparseMatrix}
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param u Matrix of samples of the random effects. Each column is a sample.
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param start Vector of starting values for the optimisation
#' @param tol The tolerance of the numerical differentiation routine
#' @param trace Integer indicating what to report to the console, 0= nothing, 1-3=detailed output
#' @return The estimated Hessian matrix
#' @examples
#' \donttest{
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(10) * t(3)) > i(5))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## simulate some values of the random effects
#' ## first, we need to extract the Cholesky decomposition of the covariance matrix D
#' L <- des$covariance$get_chol_D()
#' ## generate samples using HMC - note that this function does not use sparse methods
#' mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
#'    L = as.matrix(L),
#'    X = as.matrix(des$mean_function$X),
#'    y = as.vector(y),
#'    beta = des$mean_function$parameters,
#'    var_par = 1,
#'    family = des$mean_function$family[[1]],
#'    link = des$mean_function$family[[2]],
#'    warmup = 250, 
#'    nsamp = 250,
#'    lambda = 5,
#'    maxsteps = 100,
#'    trace=1,
#'    target_accept = 0.95)
#' ## fit model to get parameter estimates using sparse matrix methods
#' ## the covariance matrix with this specification is a sparse matrix so
#' ## we can extract the components as below
#' out <- mcml_optim_sparse(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Ap = des$covariance$D@p,
#'    Ai = des$covariance$D@i,
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    u = mat,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,3),0.25,0.7,1.0),
#'    trace=0,
#'    mcnr = TRUE)
#' ## get hessian matrix
#' hess <- mcml_hess_sparse(cov=ddata$cov,
#'   data=ddata$data,
#'   eff_range = rep(0,30),
#'   Ap = des$covariance$D@p,
#'   Ai = des$covariance$D@i,
#'   Z = as.matrix(des$covariance$Z),
#'   X = as.matrix(des$mean_function$X),
#'   y = y,
#'   u = mat,
#'   family = des$mean_function$family[[1]],
#'   link=des$mean_function$family[[2]],
#'   start = c(out$beta,out$theta,out$sigma))
#' }
mcml_hess_sparse <- function(cov, data, eff_range, Ap, Ai, Z, X, y, u, family, link, start, tol = 1e-5, trace = 0L) {
    .Call(`_glmmrMCML_mcml_hess_sparse`, cov, data, eff_range, Ap, Ai, Z, X, y, u, family, link, start, tol, trace)
}

#' Calculates the conditional Akaike Information Criterion for the GLMM
#' 
#' Calculates the conditional Akaike Information Criterion for the GLMM. These functions are not intended to be used by the general user since 
#' the complete model fitting algorithm can be accessed through the member functions of the \link[glmmrMCML]{ModelMCML}  class. 
#' These functions are exported for users wishing to use the modular components or each step 
#' separately of the MCML algorithm.
#' 
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param Z Matrix Z of the GLMM
#' @param X Matrix X of the GLMM
#' @param y Vector of observations
#' @param u Matrix of samples of the random effects. Each column is a sample.
#' @param family Character specifying the family
#' @param link Character specifying the link function
#' @param beta_par Vector specifying the values of the mean function parameters to estimate the AIC at
#' @param cov_par Vector specifying the values of the covariance function parameters to estimate the AIC at
#' @return Estimated conditional AIC
#' @examples
#' \donttest{
#' ## small example with simulated data
#' ## create data and model object with 
#' ## parameters to simulate data and 
#' ## act as starting values
#' df <- nelder(~(j(10) * t(3)) > i(5))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## simulate data
#' y <- des$sim_data()
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## get parameter estimates using Laplace approximation
#' ## this function also returns estimates of the random 
#' ## effects
#' out <- mcml_la_nr(cov=ddata$cov,
#'    data=ddata$data,
#'    eff_range = rep(0,30),
#'    Z = as.matrix(des$covariance$Z),
#'    X = as.matrix(des$mean_function$X),
#'    y = y,
#'    family = des$mean_function$family[[1]],
#'    link=des$mean_function$family[[2]],
#'    start = c(rep(0.01,5),0.25,0.7,1.0),
#'    usehess = FALSE,
#'    tol=1e-2,verbose=FALSE,trace=0)
#' ## get AIC
#' aic_mcml(cov=ddata$cov,
#'   data=ddata$data,
#'   eff_range = rep(0,30),
#'   Z = as.matrix(des$covariance$Z),
#'   X = as.matrix(des$mean_function$X),
#'   y = y,
#'   u = out$u,
#'   family = des$mean_function$family[[1]],
#'   link=des$mean_function$family[[2]],
#'   beta = c(out$beta,out$sigma),
#'   cov_par = out$theta)
#'   }
aic_mcml <- function(cov, data, eff_range, Z, X, y, u, family, link, beta_par, cov_par) {
    .Call(`_glmmrMCML_aic_mcml`, cov, data, eff_range, Z, X, y, u, family, link, beta_par, cov_par)
}

#' Multivariate normal log likelihood
#' 
#' Calculates the log likelihood of the multivariate normal distribution using `glmmr` covariance representation.
#' 
#' @param cov An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
#' in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.
#' @param data Vector of data. Created by flattening the matrices in column-major order of the data used in each block.
#' @param eff_range Vector of values with the effective range parameters of the covariance functions, where required.
#' @param gamma Vector specifying the values of the covariance function parameters
#' @param u Matrix (or vector) of observed values
#' @return Scalar value 
#' ## small example with simulated random effects
#' ## first, create data and model object with parameters
#' df <- nelder(~(j(10) * t(3)) > i(5))
#' des <- ModelMCML$new(
#'  covariance = list(
#'   formula =  ~(1|gr(j)*ar1(t)),
#'   parameters = c(0.25,0.7)
#' ),
#' mean = list(
#'   formula = ~factor(t)-1,
#'   parameters = rnorm(3)
#' ),
#' data=df,
#' family=gaussian()
#' )
#' ## get covariance definition matrix
#' ddata <- des$covariance$get_D_data()
#' ## simulate some values of the random effects
#' ## first, we need to extract the Cholesky decomposition of the covariance matrix D
#' L <- des$covariance$get_chol_D()
#' ## generate samples using HMC
#' mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
#'    L = as.matrix(L),
#'    X = as.matrix(des$mean_function$X),
#'    y = as.vector(y),
#'    beta = des$mean_function$parameters,
#'    var_par = 1,
#'    family = des$mean_function$family[[1]],
#'    link = des$mean_function$family[[2]],
#'    warmup = 250, 
#'    nsamp = 250,
#'    lambda = 5,
#'    maxsteps = 100,
#'    trace=1,
#'    target_accept = 0.95)
#' ## calculate the log likelihood for the simulated random effects
#' mvn_ll(cov=ddata$cov,
#'   data=ddata$data,
#'   eff_range = rep(0,30),
#'   gamma = c(0.25,0.7),
#'   u = mat) 
mvn_ll <- function(cov, data, eff_range, gamma, u) {
    .Call(`_glmmrMCML_mvn_ll`, cov, data, eff_range, gamma, u)
}

