% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_s3_functions.R
\name{predict.Model}
\alias{predict.Model}
\title{Generate predictions at new values from a `Model` object}
\usage{
\method{predict}{Model}(object, newdata, offset = rep(0, nrow(newdata)), m = 0, ...)
}
\arguments{
\item{object}{A `Model` object.}

\item{newdata}{A data frame specifying the new data at which to generate predictions}

\item{offset}{Optional vector of offset values for the new data}

\item{m}{Number of samples of the random effects to draw}

\item{...}{Further arguments passed from other methods}
}
\value{
A list with the linear predictor, parameters (mean and covariance matrices) for
the conditional distribution of the random effects, and any random effect samples.
}
\description{
Generates predicted values from a `Model` object using a new data set to specify covariance 
values and values for the variables that define the covariance function.
The function will return a list with the linear predictor, conditional 
distribution of the new random effects term conditional on the current estimates
of the random effects, and some simulated values of the random effects if requested. Typically 
this functionality is accessed using `Model$predict()`, which this function provides a wrapper for.
}
